#!/bin/sh
# install symlinks, preserve original if exist

# init
if [ -e ./bin/busybox-init ]; then
	[ -e ./sbin/init ] && mv ./sbin/init  ./sbin/init-FULL
	ln -s ../bin/busybox-init ./sbin/init
fi

# klogd and syslogd
if [ -e ./bin/busybox-logger ]; then
	[ -e ./sbin/klogd ]   && mv ./sbin/klogd   ./sbin/klogd-FULL
	[ -e ./sbin/syslogd ] && mv ./sbin/syslogd ./sbin/syslogd-FULL
	ln -s ../bin/busybox-logger ./sbin/klogd
	ln -s ../bin/busybox-logger ./sbin/syslogd
fi

# login passwd su
if [ -e ./bin/busybox-login ]; then
	[ -e ./bin/login ]   && mv ./bin/login   ./bin/login-FULL
	[ -e ./bin/passwd ]  && mv ./bin/passwd  ./bin/passwd-FULL
	[ -e ./bin/su ]      && mv ./bin/su      ./bin/su-FULL
	ln -s busybox-login ./bin/login
	ln -s busybox-login ./bin/passwd
	ln -s busybox-login ./bin/su
fi

# getty
if [ -e ./bin/busybox-getty ]; then
	[ -e ./sbin/getty ]  && mv ./sbin/getty ./sbin/getty-FULL
	ln -s ../bin/busybox-getty ./sbin/getty
fi

# crond crontab
if [ -e ./bin/busybox-cron ]; then
	[ -e ./bin/crontab ] && mv ./bin/crontab  ./bin/crontab-FULL
	[ -e ./sbin/crond ]  && mv ./sbin/crond   ./sbin/crond-FULL
	ln -s busybox-cron        ./bin/crontab
	ln -s ../bin/busybox-cron ./sbin/crond
fi

# inotifyd
if [ -e ./bin/busybox-inotifyd ]; then
	[ -e ./sbin/inotifyd ]  && mv ./sbin/inotifyd   ./sbin/inotifyd-FULL
	ln -s ../bin/busybox-inotifyd ./sbin/inotifyd
fi

# sleep
if [ -e ./bin/busybox-sleep ]; then
	[ -e ./bin/sleep ] && mv ./bin/sleep ./bin/sleep-FULL
	ln -s ../bin/busybox-sleep ./bin/sleep
fi

