#!/bin/sh
#
# insert into desktop files i18n info from file $1 created by simple grep commands
#

# define env KEEP_QUIET to be less verbose

OUT=/tmp/my_desktop_infos_   # file for sharing

extract_my_desktop_files ()
{
  LL=${LANG%_*} # example for <Portuguese (Portugal AND Brazil)
  
  OUT=my_desktop_infos_$LL # file for sharing
  # extract ITEM[$LL
  rm $OUT
  for ITEM in Name Comment ; do
    grep "${ITEM}\[${LL}" /usr/share/desktop-directories/* | cut -d'/' -f4- >> ${OUT}
    grep "${ITEM}\[${LL}" /usr/share/applications/*        | cut -d'/' -f4- >> ${OUT}
  done
}
#extract_my_desktop_files

# example content for $OUT:
# applications/abiword.desktop:Name[nl]=Tekstverwerker
# applications/abiword.desktop:GenericName[fr]=Traitement de texte
# applications/abiword.desktop:Comment[es]=Procesador de textos Abiword
# desktop-directories/Puppy-UtilitySub.directory:Name[pt]=Ferramentas Gerais
# desktop-directories/Puppy-UtilitySub.directory:Comment[fi]=Yleiset apuohjelmat
#
################################################################################

#import_info_for_desktop_files
# ex: update_desktop_files.sh /tmp/my_desktop_infos_*
for IN in $@ ; do

  [ -f $IN ] || { echo no input file $IN; exit 1; }
  [ "`grep -m 1 desktop $IN`" ] || { echo no desktop in input file $IN; exit 1; }

  while read LINE; do

    FILE="${LINE%%:*}"
    NAMELINE="${LINE##*:}"
    NAME="${NAMELINE%%=*}"

    if [ -z "$KEEP_QUIET" ]; then
      echo $LINE
      echo FILE=$FILE
      echo NAMELINE=$NAMELINE
      echo NAME=$NAME
      echo
    fi

    NAME="${NAME//[/\[}"
    NAME="${NAME//]/\]}"

	if [ -f $ROOT/usr/share/$FILE ]; then
		sed -i "/${NAME}/d"   $ROOT/usr/share/$FILE # delete 
		echo "${NAMELINE}" >> $ROOT/usr/share/$FILE # append
	fi

  done < $IN

done
