### this file is sourced not run

# contains default environment variables for all packages
# used both during pre-build, build, and post-build
# Note: this file is purely optional - but many packages may depend on it.

# default optimisation flags
CFLAGS="-Os"
CXXFLAGS="${CFLAGS}"
export CFLAGS CXXFLAGS

# default arch-independent flags for make and configure
CONFFLAGS_NOARCH="--prefix=/usr --sysconfdir=/etc --localstatedir=/var"
CONFFLAGS64="$CONFFLAGS_NOARCH --libdir=/usr/lib64"
CONFFLAGS32="$CONFFLAGS_NOARCH --libdir=/usr/lib"

CMAKEFLAGS="-DCMAKE_INSTALL_PREFIX=/usr"
MAKEFLAGS="-j4" 
MAKEINSTALLFLAGS=''
#export ONFFLAGS MAKEFLAGS MAKEINSTALLFLAGS # usually export is not needed

MESONFLAGS_NOARCH="$CONFFLAGS_NOARCH"
MESONFLAGS64="$CONFFLAGS_NOARCH $CONFFLAGS64"
MESONFLAGS32="$CONFFLAGS_NOARCH $CONFFLAGS32"
NINJAFLAGS="$MAKEFLAGS"
NINJAINSTALLFLAGS=''
MESONCONFFLAGS_NOARCH=''
MESONCONFFLAGS64="$MESONCONFFLAGS_NOARCH"
MESONCONFFLAGS32="$MESONCONFFLAGS_NOARCH"

# for building Xorg - LFS
export XORG_PREFIX=/usr # keep in in /usr for modern systems
XORG_CONFIG_NOARCH="--prefix=$XORG_PREFIX --sysconfdir=/etc --localstatedir=/var --disable-static"
XORG_CONFIG64="$XORG_CONFIG_NOARCH --libdir=$XORG_PREFIX/lib64"
XORG_CONFIG32="$XORG_CONFIG_NOARCH --libdir=$XORG_PREFIX/lib"

### setup_arch_vars ###
# setup arch-dependent variables for preparing, building etc   
# this function is called by build-pkg.sh after including "recipe"
# prepare CLFS 64/32-bit build environment
setup_arch_vars() {
	[ -z "$PKGARCH" ] && PKGARCH=$(uname -m)
	case $PKGARCH in
		x86_64|noarch) # prepare CLFS 64-bit build environment
			LIBDIR=lib64
			export CC="gcc ${BUILD64}" \
				   CXX="g++ ${BUILD64}" \
				   PKG_CONFIG_PATH="$PKG_CONFIG_PATH64:$PKG_CONFIG_PATH" \
				   USE_ARCH=64
			CONFFLAGS="$CONFFLAGS64"
			MESONFLAGS="$MESONFLAGS64"
			MESONCONFFLAGS="$MESONCONFFLAGS64"
			export XORG_CONFIG="$XORG_CONFIG64"
			;;
		
		i?86)  # prepare CLFS 32-bit build environment
			LIBDIR=lib
			export CC="gcc ${BUILD32}" \
				   CXX="g++ ${BUILD32}" \
				   PKG_CONFIG_PATH="$PKG_CONFIG_PATH32:$PKG_CONFIG_PATH" \
				   USE_ARCH=32
			CONFFLAGS="$CONFFLAGS32"
			MESONFLAGS="$MESONFLAGS32"
			MESONCONFFLAGS="$MESONCONFFLAGS32"
			export XORG_CONFIG="$XORG_CONFIG32"
			;;
	esac
	return 0
}
