### this file is sourced not run

###### useful helpful functions for package scripts
# it is optional but many packages depend on this.

# $1-src $2-md5sum
# return 0=good, anything else=bad
pkg_integrity() {
	[ -e $1 ] || return 1
	
	echo -n checking integrity...
	echo "$2  $1" > /tmp/md5sum-check # busybox md5sum needs two spaces
	if md5sum -c /tmp/md5sum-check > /dev/null 2>&1; then
		echo ok.
	else
		echo bad checksum.
		return 1
	fi
}

# $1-SRC_DIR $2-tarball $3-md5sum 
# return 0=good, anything else=bad
pkg_check() {
	if ! pkg_integrity $1/$2 $3; then
		if type pkg_download > /dev/null; then
			pkg_download $1 $2
			pkg_integrity $1/$2 $3 || return 1
		else
			return 1
		fi
	fi
}

# $TARBALL $SRC_DIR $MD5SUM $SRC_URL
# return 0=good, anything else=bad
pkg_prepare_default() {
	if pkg_check $SRC_DIR $TARBALL $MD5SUM; then
		echo extracting $TARBALL ...
		tar -xf $SRC_DIR/$TARBALL -C tmp	
	else
		return 1
	fi
}

# $1-src-dir $2-tarball $3-source URL
# return 0=good, anything else=bad
pkg_download_default() {
	echo downloading $2
	wget -O $1/$2 "$3"
}


# autoconf standard build
# input: $MAKEFLAGS and $CONFFLAGS
pkg_build_autoconf() {
	echo CONFFLAGS: "$CONFFLAGS"
	echo MAKEFLAGS: "$MAKEFLAGS"
	echo MAKEINSTALLFLAGS: "$MAKEINSTALLFLAGS"
	cd $(find /tmp/* -maxdepth 0 -type d ! -name pkg) &&
	./configure $CONFFLAGS &&
	make $MAKEFLAGS && make $MAKEINSTALLFLAGS install	
}

### cmake standard build
# input: $MAKEFLAGS and $CMAKEFLAGS, $1-build-dir
pkg_build_cmake() {
	local BUILD_DIR=${1:-build}
	[ -z "$CMAKEFLAGS" ] && CMAKEFLAGS="-DCMAKE_INSTALL_PREFIX=/usr"
	echo CMAKEFLAGS: "$CMAKEFLAGS"
	echo MAKEFLAGS: "$MAKEFLAGS"
	echo MAKEINSTALLFLAGS: "$MAKEINSTALLFLAGS"
	cd $(find /tmp/* -maxdepth 0 -type d ! -name pkg) &&
	mkdir $BUILD_DIR && cd $BUILD_DIR &&
	cmake .. $CMAKEFLAGS &&
	make $MAKEFLAGS &&
	make $MAKEINSTALLFLAGS install	
}

### meson standard build
# input: $NINJAFLAGS and $MESONFLAGS, $1-build-dir
pkg_build_meson() {
	local BUILD_DIR=${1:-build}
	echo MESONLAGS: "$MESONFLAGS"
	echo NINJAFLAGS: "$NINJAFLAGS"
	echo NINJAINSTALLFLAGS: "$NINJAINSTALLFLAGS"
	cd $(find /tmp/* -maxdepth 0 -type d ! -name pkg) &&
	mkdir $BUILD_DIR && cd $BUILD_DIR &&
	meson $MESONFLAGS .. &&
	if [ "$MESONCONFFLAGS" ]; then
		meson configure $MESONCONFFLAGS
	fi &&
	ninja $NINJAFLAGS &&
	ninja $NINJAINSTALLFLAGS install
}


# perl module standard build
pkg_build_perlmodules() {
	echo MAKEFLAGS: "$MAKEFLAGS"
	echo MAKEINSTALLFLAGS: "$MAKEINSTALLFLAGS"
	cd $(find /tmp/* -maxdepth 0 -type d ! -name pkg) &&
	perl Makefile.PL &&
	make $MAKEFLAGS && make $MAKEINSTALLFLAGS install	
}

# python module standard build
pkg_build_pythonmodules() {
	cd $(find /tmp/* -maxdepth 0 -type d ! -name pkg) &&
	python setup.py build &&
	python setup.py install \
		--single-version-externally-managed \
		--root /
}

# write slack-desc and slack-required
# $1-root
pkg_build_slackdesc() {
	# slack-desc
	mkdir -pv $1/install
	[ "$SLACKDESC" ] && echo "$SLACKDESC" > $1/install/slack-desc
	[ "$SLACKREQ" ]  && echo "$SLACKREQ" | sed -e 's/ *\([<=>][<=>]*\) */\1/g; s/  *\?/\n/g; s/\([<=>][<=>]*\)/ \1 /g; s/\\//g;' | sed ' /^$/d' > $1/install/slack-required
	[ "$SLACKSUG" ]  && echo "$SLACKSUG" | sed -e 's/ *\([<=>][<=>]*\) */\1/g; s/  *\?/\n/g; s/\([<=>][<=>]*\)/ \1 /g; s/\\//g;' | sed ' /^$/d' > $1/install/slack-suggests
	[ "$SLACKCON" ]  && echo "$SLACKCON" | sed -e 's/ *\([<=>][<=>]*\) */\1/g; s/  *\?/\n/g; s/\([<=>][<=>]*\)/ \1 /g; s/\\//g;' | sed ' /^$/d' > $1/install/slack-conflicts	
	[ "$SLACKINSTALL" ]   && cat > $1/install/doinst.sh << EOF && chmod +x $1/install/doinst.sh
#!/bin/sh
$SLACKINSTALL
EOF
	[ "$SLACKUNINSTALL" ] && cat > $1/install/slack-uninstall.sh << EOF && chmod +x $1/install/slack-uninstall.sh
#!/bin/sh
$SLACKUNINSTALL
EOF

	return 0
}

# make a package from a ready-made directory
# $1-dir, defaults to tmp/pkg, PKG_NOCHOWN -> don't do chown
pkg_package_dir() {
	cd ${1:-tmp/pkg} &&
	find . -type f -name 'placeholder_for_fossil' -delete &&
	if [ -z $PKG_NOCHOWN ]; then
		chown -R -h 0:0 . || return 1
	fi
	pkg_build_slackdesc . &&
	rm -f recipe &&
	$MAKEPKG -c n -l n $OUTPUT_DIR/$PKG.$PKG_TYPE > /dev/null 2>&1	
}

###### default interface functions, can be overridden if needed

# $1-src-dir $2-tarball $SRC_URL
# return 0=good, anything else=bad
pkg_download() {
	pkg_download_default $1 $2 "$SRC_URL"
}

pkg_prepare() {
	pkg_prepare_default
}

pkg_package() {
	: nothing to do
}

pkg_build() {
	pkg_build_autoconf && pkg_build_slackdesc
}

TARBALL= # the package's tarball
MD5SUM=  # package's md5sum
SRC_URL= # source URL to download the package
BUNDLE=  # if the tarball is contained within a bundle
SLACKDESC= # slackware pkg info (will go to install/slack-desc)
SLACKREQ=  # slackware pkg dependency (will go to install/slack-required)
SLACKSUG=  # slackware pkg suggested dependency (will go to install/slack-suggests)
SLACKCON=  # slackware pkg conflicts (will go to install/slack-conflicts)
SLACKINSTALL=   # slackware pkg install script install/doinst.sh
SLACKUNINSTALL= # slackware pkg uninstall script install/slack-uninstall.sh
