#!/bin/ash
# wrap mount/umount so that we can capture device mounted status to update our Rox desktop icons
# (C) James Budiono 2012, 2013
# License: GNU GPL Version 3 or later
# OBSOLETE since 711, replaced with mountmon

########## helpers ##########
# $@-original parameters, returns DEVNAME
find_device() {
	while [ "$1" ]; do
		case "$1" in 
			/dev/*) DEVNAME=$1; break ;;
			UUID=*) DEVNAME=$(blkid -U ${1#UUID=}); break ;; 
			LABEL=*) DEVNAME=$(blkid -L ${1#LABEL=}); break ;; 
			*) shift ;;
		esac
	done
}

# $@-original parameters, returns DEVNAME
# slow for general use, decent for common use cases
find_device_by_mountpoint() {
	while [ "$1" ]; do
		DEVNAME=$(awk -v mntpoint="$1" '$2 == mntpoint { print $1; exit; }' /proc/mounts)
		case $DEVNAME in 
			"") shift ;;
			*) break ;; # found it
		esac
	done
}

########## main ##########
# do the work, while capturing the device name in DEVNAME
[ $(id -u) -eq 0 ] && NO_MTAB=-n # only root can use this
case "$0" in 
	*umount) find_device "$@" 
			 [ -z $DEVNAME ] && find_device_by_mountpoint "$@"
			 umount-FULL $NO_MTAB "$@" ;;
			 
	*mount) find_device "$@" 
			mount-FULL $NO_MTAB "$@" ;;
esac
EXIT_CODE=$?

# update icon status
[ $DEVNAME ] && /usr/sbin/fatdog-drive-icon-refresh-icon.sh $DEVNAME
exit $EXIT_CODE
