#!/bin/sh

# step 20211003
# sync Xorg's splash image from ROX-filer's backdrop before Xorg starts

sync_xorg_splash_from_rox_backdrop () {
	local pinboard_file="$XDG_CONFIG_HOME/rox.sourceforge.net/ROX-Filer/PuppyPin"
	local splash="$FATDOG_STATE_DIR/xinitrc-splash"
	local style backdrop line
	while read line; do
		case "$line" in
			"/pinboard/backdrop/@style="* ) style="${line#*=}"; continue ;;
			"/pinboard/backdrop="* ) backdrop="${line#*=}"; break ;;
		esac
	done <<-EOF
	$(xml2 < "$pinboard_file")
	EOF

	# create/update link to backdrop file w/o clobbering a regular file
	if [ -e "$backdrop" ];  then
		if [ ! -e "$splash" -o -L "$splash" ]; then
			[ "$backdrop" = "$(readlink "$splash")" ] ||
				ln -sfT "$backdrop" "$splash"
		fi
	fi
}
sync_xorg_splash_from_rox_backdrop

