#!/bin/dash
# workaround for nvidia tearing problem
# requires nvidia proprietary driver

! type nvidia-settings > /dev/null && exit # quick exit if nvidia-settings

OPTIONS='{ ForceCompositionPipeline = On }' # workaround options

# get all active display with their current resolution
cmdline=""
while read -r p; do
	cmdline="$cmdline$p $OPTIONS, "
done << EOF
$(xrandr | awk '
$2=="connected" {
	output=$1
	scan=1
	next
}
$2=="disconnected" {
	scan=0
	next
}
scan && $2~/\*/ {
	print output ": " $1
}
')
EOF
cmdline=${cmdline%, }
#echo $cmdline
nvidia-settings --assign CurrentMetaMode="$cmdline"
#nvidia-settings --assign CurrentMetaMode="DFP-0: 1920x1200 { ForceCompositionPipeline = On }, CRT-0: 1920x1080 { ForceCompositionPipeline = On }
