#!/bin/ash
# jamesbond 2011, 2014, 2019, 2021
# 131130 L18L internationalisation

# std localisation stanza
export TEXTDOMAIN=fatdog
. gettext.sh
# performance tweak - use "C" if there is no localisation
! [ -e $TEXTDOMAINDIR/${LANG%.*}/LC_MESSAGES/$TEXTDOMAIN.mo ] &&
! [ -e $TEXTDOMAINDIR/${LANG%_*}/LC_MESSAGES/$TEXTDOMAIN.mo ] && LANG=C

### configuration
APPTITLE="$(gettext 'Alsa Equaliser')"
SPOT_HOME=$(awk -F: '$1=="spot" {print $6}' /etc/passwd)
ASOUNDRC=${ASOUNDRC:-$HOME/.asoundrc}

ROOT_SPOT="
	spot \"For apps running as spot (browser, free-tube, etc)\"
	root \"For apps running as root (vlc, ffmpeg, etc)\"
"

### helpers
# $1-info $2-timeout (in ms)
infobox() {
	local timeout=${2:-10000}
	if [ $DISPLAY ]; then
		Xdialog --title "$APPTITLE" --infobox "$1" 0 0 $timeout
	else
		dialog --backtitle "$APPTITLE" --no-cancel --pause "$1" 12 60 $(( timeout/1000 )) > /dev/stderr
	fi
}

# $1-text, $2-choices, output: stdout
choices() {
	if [ $DISPLAY ]; then
		eval Xdialog --title \"$APPTITLE\" --stdout --no-tags --menubox \""$1"\" 20 100 5 $2
	else 
		eval dialog --backtitle \"$APPTITLE\" --stdout --no-tags --menu \""$1"\" 0 0 0 $2
	fi
}

### main
if grep -q ctl.equal $ASOUNDRC 2> /dev/null; then
	if [ $(id -u) -eq 0 ]; then
		case $(choices "Which apps do you use for listening test?" "$ROOT_SPOT") in
			root) # change root's settings, then copy back to spot
				alsamixer -D equal
				cp /root/.alsaequal.bin $SPOT_HOME
				;;
			spot) # change spot's settings, then copy back to root
				su spot -c "alsamixer -D equal"
				cp $SPOT_HOME/.alsaequal.bin /root
				;;
		esac
	else
		alsamixer -D equal
	fi
else
	infobox "$(eval_gettext '$APPTITLE turned off, it must be turned on for this to work.')" 10000
fi

