#!/bin/sh

### find default card, if any
for p in $HOME/.asoundrc /etc/asound.conf; do
	if [ -e "$p" ]; then
		unset card sub
		while read line; do
			case $line in
				\#*                                        ) continue ;;
				*ctl.!default*[\ \	]card[\ \	]* ) card=$line; break ;;
				*ctl.!default*                             ) sub=true; continue ;;
				*card*                                     ) if [ "$sub" ]; then card=$line; break; fi ;;
				*\}*                                       ) unset sub; continue ;;
			esac
		done < "$p"
		if [ "$card" ]; then
			card=$(set -- ${card##*card}; echo ${1%\}})
			break
		fi
	fi
done
if [ "$card" ]; then
	exec alsamixer -c $card
fi
exec alsamixer "$@"
