#!/bin/dash
# jamesbond 2010, 2015, 2019
# Previously known as pdiag.sh; now made specific to Fatdog

APPTITLE="Bug Report Tool"
WORKDIR=/tmp/bugreport.$$
BUGREPORT_FILE=bugreport.txt

############ helpers ##############
trap 'cleanup; exit;' 0 HUP INT TERM

cleanup() {
	[ -d $WORKDIR ] && rm -r $WORKDIR
}

dlg() {
	if [ "$DISPLAY" ]; then
		Xdialog --title "$APPTITLE" "$@" 
	else
		dialog --title "$APPTITLE" "$@" 
	fi
}

### $*-msg to display
infobox() {
	[ $XPID ] && kill $XPID 2>/dev/null
	if [ "$DISPLAY" ]; then
		Xdialog --title "$APPTITLE" --no-buttons --infobox "$*" 0 0 1000000 &
		XPID=$!
	else
		dialog --title "$APPTITLE" --infobox "$*" 0 0
	fi
}

msgbox() {
	[ $XPID ] && kill $XPID 2>/dev/null
	XPID=""
	if [ "$DISPLAY" ]; then
		Xdialog --title "$APPTITLE" --msgbox "$*" 0 0
	else
		dialog --title "$APPTITLE" --msgbox "$*" 0 0
	fi
}

# $1-folder
preview() {
	if [ "$DISPLAY" ]; then
		rox $1
		msgbox "Please review the contents of reports to be sent.
Delete what you don't want to share.
When done, click OK."
		rox -D $1
	else
		msgbox "Launch another console to review contents of $PWD.
Delete what you don't want to share.
When done, click OK."
	fi
}

# for tar-ring proc and sys
# $1-tarball filename, $2... subdir to copy and tar
tar_copy() {
	local tarball=$1 root
	shift
	[ "$1" ] && root=${1#/} root=${root%%/*} && mkdir $root
	while [ "$1" ]; do
		find $1 -type f | while read F ; do
		   D="./$(dirname $F)"
		   test -d "$D" || mkdir -p "$D" 2>/dev/null
		   test -f "./$F" || cat $F > "./$F" 2>/dev/null
		done
		shift
	done
	[ -d $root ] && tar -cf $tarball $root/*
	[ -d $root ] && rm -r $root
}

############# main ############
#DISPLAY=""
mkdir -p $WORKDIR; cd $WORKDIR
echo "Describe the nature of the problem:" > tmp
if ! dlg --ok-label "Next" --editbox tmp 25 80 2> $BUGREPORT_FILE; then
	infobox "Cancelled."
	exit 0
fi
rm tmp

###
infobox "Collecting shell information..."
env > env.txt
set > set.txt
ps -ef f > ps.txt

infobox "Collecting package information..."
ls /var/log/packages/* > installed_pkg.txt

infobox "Collecting boot and kernel information..."
cp /dev/initrd.err .
cp /etc/rc.d/PUPSTATE .
cp /etc/BOOTSTATE .
cp /etc/modules etc_modules
dmesg > dmesg.txt
lsmod > lsmod.txt
lspci > lspci.txt
lspci -v > lspci_v.txt
lsusb > lsusb.txt
lsusb -v > lsusb_v.txt
tar_copy proc_sys.tar /proc/cpuinfo /proc/sys /proc/cmdline /proc/bus/input \
         /proc/partitions /proc/self/mounts /proc/self/net /proc/acpi
tar -cf sys_power_supply.tar /sys/class/power_supply/*/*
tar -cf modprobe.d.tar /etc/modprobe.d/*
tar -cf udev.tar /tmp/udev/*

infobox "Collecting Xorg information..."
cp /var/log/Xorg.0.log xorg.log.txt
cp /etc/X11/xorg.conf xorg.conf.txt
tar -cf xorg.conf.d.tar /etc/X11/xorg.conf.d/* /usr/share/X11/xorg.conf.d/*
xinput > xinput.txt
xrandr --verbose > xrandr.txt
xrandr --listproviders > xrandr-providers.txt
glxinfo > glxinfo.txt
vdpauinfo > vdpauinfo.txt 2>&1

infobox "Collecting ALSA information..."
tar_copy proc_asound.tar /proc/asound
ls -l /dev/snd/* > dev_snd.txt
ls -l /dev/dsp* /dev/mixer* > dev_dsp.txt
amixer scontents > amixer.txt
cp ~/.asoundrc asoundrc-$USER
cp /root/.asoundrc asoundrc-root
cp /home/spot/.asoundrc asoundrc-spot

infobox "Collecting network information..."
cp /etc/resolv.conf .
ifconfig -a > ifconfig.txt 2>&1
iwconfig > iwconfig.txt 2>&1
route -n > route.txt
ip addr > ip_addr.txt 
ip link > ip_link.txt
ip route > ip_route.txt
iptables -L -vn > iptables.txt
iptables -t nat -L -vn > iptables_nat.txt

infobox "Collecting disks and aufs information..."
probedisk2 > probedisk2.txt
probepart > probepart.txt
losetup -a > losetup.txt
for p in /sys/fs/aufs/*; do 
	echo $p
	for q in $p/br[0-9]*; do 
		read qq < $q
		echo "${q##*/}: $qq"
	done
	echo
done > aufs_branches.txt
tar -cf udev-drive-icon.tar /tmp/udev-fatdog-drive-icon/*
ls -ld / /* /aufs /aufs/*  > dirperms.txt
blkid > blkid.txt
 
infobox "Collecting machine information..."
hardinfo -r -m computer.so -m devices.so -m network.so > hardinfo.txt
dmidecode > dmidecode.txt

preview $PWD

OUTPUT=$HOME/bugreport.tar.xz
if [ $(id -u) -eq 0 ]; then
	OUTPUT=/root/Downloads/bugreport.tar.xz
fi
tar -cJf $OUTPUT *
msgbox "Your report has been created and stored in $OUTPUT.
Please send it to Fatdog developers."
