#!/bin/dash
# fatdog-battery-applet.sh, replacement for powerapplet
# display an icon on icon tray showing how much battery charge is left
# (C) James Budiono 2014
# License: GPL Version 3 or later
#
# uses 'sit' (simple-icon-tray) from technosaurus
#
# Note: doesn't deal with multiple power supplies and multiple batteries,
# only the first one is shown.

### configuration
CHECK_EVERY=60 #seconds
POWER_PATH=/sys/class/power_supply
IMG_FILE=/tmp/batt.$$.svg
TOOLTIP=/tmp/batt.$$.tip
ACTION=/tmp/batt.$$.action
LOWBATT=15 # % left
#LOWBATT_ACTION='xmessage -center WARNING: Battery Low. Automatic shutdown imminent. Connect charger now.'
LOWBATT_ACTION='batt-low.sh critical'
CLICK_ACTION="Xdialog --left --title \"Battery Info\" --msgbox \"\$(cat $POWER_PATH/*/uevent | sed 's/=/:    /')\" 0 0"
[ -e /etc/battery.conf ] && . /etc/battery.conf # configuration

BATTERY_SVG='<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<svg version="1.0" width="60" height="60" x="0" y="0">
  <rect id="body"   x="14" y="15" height="40" width="32" rx="3" ry="3" style="fill:white;stroke:black;stroke-width:3;"/>
  <rect id="charge" x="15" y="16" height="38" width="30" rx="3" ry="3" style="fill:red;stroke:none;"/>
  <rect id="cap"    x="22" y="9"  height="6"  width="16" rx="3" ry="3" style="fill:white;stroke:black;stroke-width:3;"/>
  <path id="online" d="M26,20 H38 L32,30 L36,38 L22,50 L26,36 L20,32 z" style="fill:yellow;stroke:black;stroke-width:2" />
</svg>'
CHARGE_MAX=38
CHARGE_OFF=16

# $1-online $2-capacity
update_image() {
	# charges
	charge_sed="/charge/d" colour_sed=""
	if [ "$2" ]; then
		echo -n "${2}% battery left." > $TOOLTIP
		charge=$(($2*CHARGE_MAX/100))
		offset=$((CHARGE_OFF+CHARGE_MAX-charge))
		charge_sed="/charge/ {s|y=\"$CHARGE_OFF\"|y=\"$offset\"|; s|height=\"$CHARGE_MAX\"|height=\"$charge\"|}"
		[ $2 -ge 30 ] && colour_sed="/charge/ s|:red|:cyan|"		
		[ $2 -ge 70 ] && colour_sed="/charge/ s|:red|:green|"
	fi
	#echo $charge_sed
	
	# ac power
	power_sed="/online/d"
	[ "$1" ] && [ $1 -eq 1 ] && power_sed=""
	
	# output image
	echo "$BATTERY_SVG" | sed -e "$charge_sed" -e "$colour_sed" -e "$power_sed" > $IMG_FILE
	
	# check battery low
	if [ "$power_sed" ] && [ "$2" ] && [ $2 -le $LOWBATT ]; then
		$LOWBATT_ACTION & # don't block
	fi
}

### main ###
update_image 0
touch $TOOLTIP
printf "%s\n%s &" "#!/bin/dash" "$CLICK_ACTION" > $ACTION; chmod +x $ACTION
sit $IMG_FILE $TOOLTIP $ACTION $ACTION &
XPID=$!
trap '{ kill $XPID; rm $IMG_FILE $TOOLTIP $ACTION; } 2>/dev/null; exit' INT TERM HUP 0

while :; do
	online=$(cat $POWER_PATH/*/online 2>/dev/null | head -n 1)
	capacity=$(cat $POWER_PATH/*/capacity 2>/dev/null | head -n 1)
	if [ -z "$capacity" ]; then
		# try charge
		full=$(cat $POWER_PATH/*/charge_full 2>/dev/null | head -n 1)
		now=$(cat $POWER_PATH/*/charge_now 2>/dev/null | head -n 1)
		if [ -z "$full" ] || [ -z "$now" ]; then
			# try energy
			full=$(cat $POWER_PATH/*/energy_full 2>/dev/null | head -n 1)
			now=$(cat $POWER_PATH/*/energy_now 2>/dev/null | head -n 1)				
		fi
		if [ $full ] && [ $now ]; then
			: $((capacity = full * 100 / now))
		fi
	fi
	[ $capacity ] || exit # can't find capacity measurement, leave
	kill -0 $XPID || exit # if sit dies, we leave too
	kill -STOP $XPID # SFR - continue sit
	update_image "$online" "$capacity"
	kill -CONT $XPID # SFR - continue sit
	sleep $CHECK_EVERY
done
