#!/bin/ash
# Quick Apps - create shortcut to often used applications
# Copyright (C) James Budiono 2012, 2021
# License: GNU GPL Version 3 or later
#
# i18n by L18L

export TEXTDOMAIN=fatdog
. gettext.sh

### configuration
APPTITLE="$(gettext 'QuickApps')"
APPICON=/usr/share/pixmaps/midi-icons/go48.png	# temporary icon
QUICKAPPS_HOME="$HOME/$APPTITLE"
DESKTOP_FILES_DIR=/usr/share/applications
REBUILD_LINK='0-Finish-Configuration'
INDEX_FILE=.apps

##################### helper #####################

create_quickapps() {
	# if already exist, do nothing
	[ -d "$QUICKAPPS_HOME" ] && return
	
	# otherwise, create it
	mkdir -p "$QUICKAPPS_HOME"
	ln -sfT $(readlink -f "$0") "$QUICKAPPS_HOME/AppRun"
	ln -sfT $(readlink -f "$0") "$QUICKAPPS_HOME/$REBUILD_LINK"
	
	# create AppInfo.xml
	cat > "$QUICKAPPS_HOME/AppInfo.xml" <<EOF
<?xml version="1.0"?>
<AppInfo>
  <Summary>$APPTITLE</Summary>
  <About>
    <Purpose>$(gettext 'Application Launcher - create shortcuts for often-used applications')</Purpose>
    <Version>1.0</Version>
    <Authors>James Budiono</Authors>
    <License>GNU General Public License Version 3 or Later</License>
  </About>
  <AppMenu>
    <Item option="configure" icon="gtk-preferences">
      <Label>$(gettext 'Add/remove application shortcuts')</Label>
    </Item>
  </AppMenu>
</AppInfo>		
EOF
	ln -sfT "$APPICON" "$QUICKAPPS_HOME/.DirIcon"
}

launch_app() {
	fatdog-control-panel.sh "$APPTITLE" "$QUICKAPPS_HOME/$INDEX_FILE"
}

configure_app() {
	rox -d "$QUICKAPPS_HOME"
	rox -d "$DESKTOP_FILES_DIR"
    TEXT="$(eval_gettext 'Two folders have been opened. \n
One is the ${APPTITLE} folder, the other one is the "All applications folder". \n
You can identify them by looking at the window title. \n 

To add a shortcut, follow these three easy steps:')
    
1. $(eval_gettext 'Create a new folder in the ${APPTITLE} folder. \n 
   This new folder serves as "Category" and will appear as a tab in the ${APPTITLE}.')
   
2. $(gettext "From the \"All applications folder\", select then drag and drop the applications you want 
   into the \"Category\" folder you created in step 1. Choose \"Link\" when asked.")
   
3. $(eval_gettext 'Repeat step 1 & 2 as necessary. 

When done, click "${REBUILD_LINK}" on the ${APPTITLE} folder.')
   
$(eval_gettext '${APPTITLE} is available from your Home folder.') "

	Xdialog --title "$APPTITLE" --left --infobox "$TEXT" 0 0 90000
}

rebuild_app() {
	rox -D "$QUICKAPPS_HOME"
	rox -D "$DESKTOP_FILES_DIR"
	cd "$QUICKAPPS_HOME"
	rm $INDEX_FILE 2> /dev/null
	tab_count=0
	find . -maxdepth 1 -type d | sed '1 d; s_\./__' | while read p; do
		tab_count=$((tab_count + 1))
		{ 
			echo -n TAB${tab_count}_TAB=\'$p\| 
			ls "$p" | sed 's/.desktop$//' | tr '\n' ' '
			echo \' 
		} >> $INDEX_FILE
	done
}

############# main ##############
# check how we're launched - directly or as rox app?
case $0 in 
	*AppRun) # as rox app
		case $1 in
			"") 		launch_app ;;
			configure)	configure_app ;;
		esac ;;
	
	*$REBUILD_LINK) # to finish configuration
		rebuild_app ;;	# as "
		
	*)	# as standalone app - do configure
		create_quickapps; exec "$QUICKAPPS_HOME/AppRun" configure ;; 
esac
