# This file is sourced by /bin/dash

# fatdog-shortcut-viewer.sh - show keyboard and mouse shortcuts
# Copyright (C) step, 2020-2021
# License: GNU GPL Version 2

### Getters ###

# Openbox window manager
get_openbox_config() { # $1-output-file-append $2-ctx-any $3-separator
	local outf="$1" ctx_any="$2" sep="$3"
	local ob_config="$HOME/.config/openbox/rc.xml"
	! [ -r "$ob_config" ] && ob_config="/etc/xdg/openbox/rc.xml"
	OBB_SQEEZE_WS=yes OBB_CTX_ANY="$ctx_any" fatdog-obb2bsv.sh < "$ob_config" >> "$outf"
}

# Dunst notification manager
get_dunst_config() { # $1-output-file-append $2-ctx-any $3-separator
	local outf="$1" ctx_any="$2" sep="$3"
	local user_conf="$HOME/.config/dunst/dunstrc" sys_conf="/etc/xdg/dunst/dunstrc"
	! [ -r "$user_conf" ] && user_conf="/dev/null"
	! [ -r "$sys_conf" ] && user_conf="/dev/null"
	awk \
	-v PAT="history|close_all|close|context" \
	-v I18N="$(gettext "previous notification|close all notifications|close notification|show notification context menu")" \
	-v OFS="$sep" -v CTX_ANY="$ctx_any" '#{{{awk
/^[[:space:]]*#/ { next }
BEGIN {
	split(PAT,  K, /\|/); split(I18N, T, /\|/)
	for(k = 1; k <= length(K); k++) { T[K[k]] = T[k] }
	delete(K)
}
$1 ~ "^("PAT")$" { K[$1] = $3 }
END { for(k in K) { print 0, CTX_ANY, K[k], T[k] } }
#awk}}}' "$sys_conf" "$user_conf" >> "$outf"
}

# Sven multimedia manager
get_sven_config() { # $1-output-file-append $2-ctx-any $3-separatoTODO
	local outf="$1" ctx_any="$2" sep="$3"
	sven -d |
	# convert format
	awk -v RS= -F"\012" -v ofs="$sep" -v CTX_ANY="$ctx_any" '#{{{awk
# skip disabled bindings
$5+0 { next }
{
	device = substr($1, index($1, "=") +1)
	sym = substr($3, index($3, "=") +1)
	description = substr($6, index($6, "=") +1)
	command = substr($7, index($7, "=") +1)
	comment = substr($8, index($8, "=") +1)

	# heuristics to shrink the desc field somewhat
	if(index(tolower(description), tolower(comment)))
		description = ""

	desc = (description ?", "description :"") (comment ?", "comment :"") (command ?", "command :"")
	desc = substr(desc, 3)

	# squeeze white space and print
	out = device ofs CTX_ANY ofs sym ofs desc
	gsub(/[[:space:]]/, " ", out); gsub(/ +/, " ", out)
	print out
}
#awk}}}' >> "$outf"
}

