#!/bin/dash

# Simple GUI for speaker-test
# (C) SFR 2017
# License: GNU GPL Version 3 or later

# std localisation stanza
export TEXTDOMAIN=fatdog
. gettext.sh

APPNAME="$(gettext 'Speaker Test')"
TMPFILE="/tmp/speaker-test.${USER}.$$"
touch "$TMPFILE"

if which gtkdialog >/dev/null 2>&1; then

	echo '
	<window title="'${APPNAME}'" resizable="false" window-position="1" image-name="/usr/share/pixmaps/mini-icons/mini-speaker.xpm">
	  <vbox>
	    <hbox>
	  	  <vbox>
	  	    <hbox>
	  	      <text xalign="0"><label>'$(gettext "Audio channels:")'</label></text>
	  	      <text space-fill="true" space-expand="true"><label>""</label></text>
	  	      <spinbutton range-min="1" range-max="8" range-step="1" range-value="2">
	  	        <variable>CHANNELS</variable>
	  	      </spinbutton>
	  	    </hbox>
	  	  	
	  	    <hbox>
	  	      <text xalign="0"><label>'$(gettext "Test sound:")'</label></text>
	  	      <text space-fill="true" space-expand="true"><label>""</label></text>
	  	      <comboboxtext>
	  	        <variable>SOUND</variable>
	  	        <item>wav ('$(gettext "WAV file")')</item>
	  	        <item>sine ('$(gettext "sine wave")')</item>
	  	        <item>pink ('$(gettext "pink noise")')</item>
	  	      </comboboxtext>
	  	    </hbox>
	  	  </vbox>
	  	
	  	  <togglebutton image-position="top" has-focus="true">
	  	    <variable>TBUT</variable>
	  	    <default>false</default>
	  	    <label>'$(gettext "Start/Stop")'</label>
	  	    <input file>/usr/share/pixmaps/mini-icons/mini-speaker.xpm</input>
	  	    <action condition="active_is_true(TBUT)">speaker-test -t${SOUND%% *} -c ${CHANNELS} > '${TMPFILE}' &</action>
	  	    <action condition="active_is_true(TBUT)">disable:CHANNELS</action>
	  	    <action condition="active_is_true(TBUT)">disable:SOUND</action>
	  	    <action condition="active_is_false(TBUT)">killall -0 speaker-test 2>/dev/null && killall speaker-test; echo > '${TMPFILE}'</action>
	  	    <action condition="active_is_false(TBUT)">enable:CHANNELS</action>
	  	    <action condition="active_is_false(TBUT)">enable:SOUND</action>
	  	  </togglebutton>
	  	  
	    </hbox>
	  	  
	    <statusbar has-resize-grip="false">
	      <variable>STATUS</variable>
	      <input>tail -n 1 '${TMPFILE}'</input>
	    </statusbar>
	      
	    <timer visible="false" milliseconds="true" interval="500">
	      <variable>TIMER</variable>
	      <action>refresh:STATUS</action>
	    </timer>
	  </vbox>
	</window>' | gtkdialog -s
	
	killall -0 speaker-test 2>/dev/null && killall speaker-test

else	# Xdialog fallback

	while true; do
		CHANNELS="$(Xdialog --stdout \
							--title "$APPNAME" \
							--ok-label "$(gettext 'Test')" \
							--cancel-label "$(gettext 'Quit')" \
							--rangebox "$(gettext 'Audio channels:')" 0 0 1 8 ${CHANNELS:-2})"
		[ $? -ne 0 ] && break
		
		speaker-test -twav -c${CHANNELS} > "${TMPFILE}" &
		SPID=$!
		
		Xdialog --title "$APPNAME" --smooth --no-ok --logbox "${TMPFILE}" 0 0
		RET=$?
		
		kill -0 $SPID 2>/dev/null && kill $SPID
		
		[ $RET -eq 255 ] && break
	done

fi

rm -f "$TMPFILE"

exit
