#!/bin/dash

export TEXTDOMAIN=get_app

### config
APPTITLE="$(gettext 'Update Libreoffice')"

### generic helpers
# $1-text
msg() {
	[ -z "$DISPLAY" ] && echo "$1" ||
	Xdialog --title "$APPTITLE" --infobox "$1" 0 0 10000
}

# are we root?
check_root() {
	if [ $(id -u) -ne 0 ]; then
		msg "$(gettext 'You must be root.')"
		exit 1
	fi
}

# $1-text, returns true/false
yesno() {
	local p
	if [ -z "$DISPLAY" ]; then
		printf "%s\nType [yes] to continue: " "$1"
		read p
		case "$p" in
			yes) return 0
		esac
		return 1
	else
		Xdialog --title "$APPTITLE" --yesno "$1" 0 0
	fi
}

### main 
check_root
! yesno "\
$(gettext 'Running this program will download the official binary of Libreoffice
from The Document Foundation, and package into SFS. This SFS can then be used
to override the built-in version of Libreoffice.')

$(gettext 'Are you sure you want to continue?')
" && exit

if [ -z "$DISPLAY" ]; then
	getlibre.sh
else
	defaultterm -e getlibre.sh
fi
