#!/bin/dash

SETVALUE=/sys/class/leds/smc::kbd_backlight/brightness
read BACKLIGHT < "$SETVALUE" || exit 1
INCREMENT=15
SET_VALUE=0
unset TOTAL

case $1 in
    up)
        TOTAL=$(($BACKLIGHT +$INCREMENT))
        [ "$TOTAL" -gt 255 ] && TOTAL=255
        ;;
    down)
        TOTAL=$(($BACKLIGHT -$INCREMENT))
        [ "$TOTAL" -lt 0 ] && TOTAL=0
        ;;
    [0-9]*)
		TOTAL=$1
		;;
    *)
        echo "Use: ${0##*/} up|down|0-255"
        exit
        ;;
esac

echo $TOTAL > "$SETVALUE"

