#!/bin/dash
# James Budiono 2011, 2013, 2014, 2016
# sb2dir.sh - sandbox to directory
# copy contents of sandbox to dir, removing all known sandboxing files
SANDBOX_ROOT=/mnt/sb
SANDBOX=$SANDBOX_ROOT/sandbox
TARGET_ROOT=/tmp

case "$1" in
	""|--help|-h)
	echo "Usage: ${0##*/} dirname [/path/to/sandbox]"
	echo "Extracts content of sandbox into $TARGET_ROOT/\$dirname directory."
	echo "If dirname starts with /, then it is copied to \$dirname instead."
	exit ;;
	
	/*) 
	TARGET_ROOT="${1%/*}"
	DIRNAME="${1##*/}" ;;
	
	*)
	DIRNAME="$1" ;;
esac
[ "$2" ] && SANDBOX="$2"

echo "Copying to $TARGET_ROOT/$DIRNAME from $SANDBOX"
mkdir -p "$TARGET_ROOT"
cd "$SANDBOX"
find . | sed -ne "
#filters - what we want to remove from output (all the whiteout files, and our own test profile/apps)
/\.wh\./ d
/\/etc\/profile$/ d
/\/etc\/shinit/ d
/\/etc\/hosts/ d
/\/etc\/hostname/ d
/\/etc\/inittab/ d
/\/etc\/\.XLOADED/ d
/\/etc\/BOOTSTATE/ d
/\/etc\/rc\.d\/rc\.sysinit\.lxc/ d
/\/sbin\/init/ d
/\/usr\/bin\/xwin/ d
/\/usr\/bin\/wmexit/ d
/\/var\/run\/utmp/ d
/\/var\/log\/wtmp/ d
/\/dev\/null/ d
/\/root\/\.Xauthority/ d
p" | cpio -d -p "$TARGET_ROOT/$DIRNAME"
cd "$TARGET_ROOT"
find "$DIRNAME" -type d -empty -delete # delete all empty directories
echo Output in $TARGET_ROOT/$DIRNAME
