#!/bin/dash
# start a remote x11vnc desktop connection using ssh
PORT=${PORT:-5900}

case "$1" in
	-h|--help|"")
		cat << EOF
ssh to remote host and launch Xvnc.
Usage: PORT=xxxx ${0##*/} ssh-parameters
Default port is $PORT. Start "vncviewer localhost:$PORT" to view.
Press Ctrl-C to quit when done, or kill Xvnc from the remote desktop.
EOF
	exit
esac

ssh -L $PORT:localhost:5920 "$@" '
pfix=nox . /etc/profile
if ! pidof Xvnc; then
	killall -9 lxqt-panel
	xinit ./.xinitrc -- /usr/bin/Xvnc :20 -interface 127.0.0.1 -SecurityTypes none -desktop "$(hostname)" -geometry 1280x800 -AlwaysShared
	killall -9 lxqt-panel
else
	echo Reconnecting to existing Xvnc process
	while pidof Xvnc > /dev/null; do sleep 1; done
	killall -9 lxqt-panel
fi
'
echo Done.
