#!/bin/dash
# (C) James Budiono 2013
# License: GPL Version 3 or later.
#
### view contents of pet package
# $1 - pet package

[ -z "$1" ] && echo "Usage: ${0##*/} package" && exit
out=$(mktemp -p /tmp viewpet.XXXXXXXX)

(
### 1. check integrity (stolen from silent_petget)
fsize=$(( $(stat -c %s "$1") - 32 ))
cksum=$(dd if="$1" bs=$fsize skip=1 2> /dev/null)
echo -n Checking package integrity ...
if [ $(dd if="$1" bs=$fsize count=1 2> /dev/null | md5sum | awk '{print $1}') != $cksum ]; then
	echo " bad pet: checksum does not match."
	exit
fi
echo " good."

### 2. List
tar -tvf "$1" 2>/dev/null | awk -v fn="$1" '
BEGIN {
	print "Contents of " fn "\n==="
}
{
	sub(/[^\/]*\/[^\/]*/,"",$6)
	for (i=6; i<=NF; i++) printf ("%s",$i)
	print ""
}
END {
	print "===\nListing completed."
}' 
) > $out &

Xdialog --title "View Pet $1" --no-cancel --tailbox $out 25 80
rm $out
