#!/bin/ash
# Find bluetooth modems and update /etc/bluetooth/rfcomm.conf
# Copyright (C) James Budiono 2013
# License: GPL Version 3 or later
#
# 131112 L18L internationalisation

# std localisation stanza
export TEXTDOMAIN=fatdog
. gettext.sh
# performance tweak - use "C" if there is no localisation
! [ -e $TEXTDOMAINDIR/${LANG%.*}/LC_MESSAGES/$TEXTDOMAIN.mo ] &&
! [ -e $TEXTDOMAINDIR/${LANG%_*}/LC_MESSAGES/$TEXTDOMAIN.mo ] && LANG=C

### configuration
APPTITLE="$(gettext 'Setup bluetooth modems')"
RFCOMM_CONF=/etc/bluetooth/rfcomm.conf

###### main ######
# 1. must run as root
[ $(id -u) -ne 0 ] && exec gtksu "$APPTITLE" "$0"

# 1.a - bluetooth must be running
if ! pidof bluetoothd > /dev/null; then
	Xdialog --title "$APPTITLE" --infobox "$(gettext 'Bluetooth service must be up and running.')" 0 0 10000
	exit
fi

# 2. ask user to turn on their modems and make it discoverable
Xdialog --title "$APPTITLE" --msgbox "$(gettext 'First, ensure that you have paired your computer with your bluetooth modem device(s).
Do that using the bluetooth applet.') 
$(gettext 'Click OK to continue.')" 0 0

Xdialog --title "$APPTITLE" --msgbox "$(gettext 'Now, please make your bluetooth modem(s) discoverable.')
$(gettext 'Click OK to continue.')" 0 0

# 3. detect modems
TMP=$(mktemp -p /tmp btmodems.XXXXXXXX)
sdptool search DUN | fatdog-bt-find-dun.awk 2>$TMP >> $RFCOMM_CONF &
Xdialog --no-buttons --title "$(gettext 'Finding modems')" --backtitle "$(gettext 'Detecting modems, please wait ...')" --tailbox $TMP 0 0 &
XPID=$!

# 4. wait while detection is done ...
while pidof sdptool > /dev/null; do sleep 1; done
sleep 5 # display result for a little longer

# 4. Complete.
kill $XPID
rm -f $TMP
rfcomm bind all
Xdialog --title "$APPTITLE" --infobox "$(gettext 'Done. Your modem(s) is ready for use.')" 0 0 10000
