#!/bin/dash
# Poll an optical drive until no disk is present. Called from fatdog-drive-icon-udev-handler.sh for each inserted optical disk.
# note: cddetect reads the disc, and will automatically generate udev change event if disc state changed (ie no disc)
#
# $1 - DEVNAME (/dev/sr0)
# OBSOLETE since 621, replaced with kernel polling

### configuration
POLL_DELAY=5					# every 5 seconds
LOCK_FILE=/tmp/${0##*/}.${1##*/}
[ -e $LOCK_FILE ] && exit		# don't run multiple copies

start_polling() {
	touch $LOCK_FILE
	while cddetect_quick -d $1; do
		sleep $POLL_DELAY
	done
	rm -f $LOCK_FILE
}

start_polling $1 &
