#!/bin/dash
# Fatdog64 Quick Setup, configure minimal setup items
# originally called firstrun-wizard

### config
APPTITLE="Fatdog64 Quick Setup"
NLS_SFS=${NLS_SFS:-fd64-nls}
HWCLOCKCONF=/etc/hwclock.conf
[ $BOOTSTATE_PATH ] && [ -f $BOOTSTATE_PATH ] && . $BOOTSTATE_PATH

export TEXTDOMAIN=fatdog
. gettext.sh


### helpers

# $@ - params
dlg() {
	Xdialog --title "$APPTITLE" "$@"
}

# attempt to load the nls sfs if it exists
load_nls() {
	# if nls not loaded, attempt to load it
	if ! [ -e /etc/fatdog-nls-version ]; then
		read version < /etc/fatdog-version
		for p in ${NLS_SFS}.sfs ${NLS_SFS}_$version.sfs; do
			if [ -f ${SAVE_DEV_MOUNT}/$p ]; then
				load_sfs.sh --load ${SAVE_DEV_MOUNT}/$p
				break
			fi 
		done
	fi
}



############ main ############

dlg --ok-label "PROCEED" --cancel-label "QUIT" --yesno "\
This is Fatdog64 Quick Setup.

It will prompt you to setup minimum configurations settings for your
system: locale, keyboard layout, hardware clock, and timezone.

These prompts themselves can be skipped (simply choose Cancel when
asked) and previous defaults will be used if any, otherwise
reasonable defaults will be used.

Please click PROCEED to continue, or QUIT to leave.

If you choose to QUIT, you can always re-run this setup later, or
configure individual items by launching them under \"Localisation\" tab
in the Control Panel.

" 0 0 30000 || exit

# the four scripts we run

# 1. NLS
[ $(id -u) -eq 0 ] && load_nls
fatdog-choose-locale.sh
[ -e $FATDOG_STATE_DIR/language ] && read LANG < $FATDOG_STATE_DIR/language &&
export LANG # next questions are all in NLS

# 2. keyboard
fatdog-keyboard-wizard.sh

# 3. Time
if [ $(id -u) -eq 0 ]; then
	hwclockconf.sh
	fatdog-set-timezone.sh	
fi

# restart notification
dlg --yesno "\
Configuration is done. If you have changed anything, they will only
take effect after the desktop is restarted.

Do you want to restart the desktop now?" 0 0 &&
DONT_ASK=1 wmexit restart
