#!/bin/ash
# jamesbond 2012 - set hostname
# 131109 L18L internationalisation

# std localisation stanza
export TEXTDOMAIN=fatdog
. gettext.sh
# performance tweak - use "C" if there is no localisation
! [ -e $TEXTDOMAINDIR/${LANG%.*}/LC_MESSAGES/$TEXTDOMAIN.mo ] &&
! [ -e $TEXTDOMAINDIR/${LANG%_*}/LC_MESSAGES/$TEXTDOMAIN.mo ] && LANG=C

### configuration
APPTITLE="$(gettext 'Set Hostname')"
HOSTNAME="$(hostname)"

[ $(id -u) -ne 0 ] && exec gtksu "$APPTITLE" "$0" "$@"

if Xdialog --title "$(gettext 'Warning!')" --yesno "$(gettext 'Changing hostname will automatically restart X server.')
$(gettext 'Do you wish to continue?')" 0 0; then
	if NEW_HOSTNAME=$(Xdialog --title "$APPTITLE" --backtitle "$(eval_gettext 'The current hostname is $HOSTNAME.')" --stdout \
	--inputbox "$(gettext 'Please enter the new hostname.')" 0 0); then
		NEW_HOSTNAME=$(echo "$NEW_HOSTNAME" | tr -d ' \t\n.~!@#$%^&*()?<>/,;:"[]{}\|=') # remove evil characters
		Xdialog --title "$(gettext 'Success!')" --infobox "$(eval_gettext 'Hostname will be changed to $NEW_HOSTNAME.') 
$(gettext 'X server will be restarted now, but the new hostname will only take full effect after reboot.')"	0 0 10000
		echo $NEW_HOSTNAME > /etc/hostname
		sed -i'' -e "1 {s/^.*$/127.0.0.1 localhost $(cat /etc/hostname)/}" /etc/hosts 
		hostname -F /etc/hostname
		DONT_ASK=1 wmexit restart
	fi
fi
Xdialog --title "$(gettext 'Cancelled!')" --infobox "$(eval_gettext 'Nothing is changed, hostname stays as $HOSTNAME')" 0 0 10000
