#!/bin/dash
# download latest google-chrome
# original by jamesbond 2015 for firefox-updater
# adulterated by kirk
# MIT license
# internationalized by L18L

export TEXTDOMAIN=get_app

### config
APPTITLE="$(gettext 'Download Google-Chrome')"
WORKDIR=/tmp/work/update-google-chrome.$$

### generic helpers
get_config() {
	if [ $(id -u) -ne 0 ]; then
		msg "$(gettext 'You must be root.')"
		exit 1
	fi
	LATEST=$(date +%Y.%m.%d) #can't determine version
	LIBDIR=lib64
	ARCH=x86_64 
	FFLANG=en-US # or others
	FF_DOWNLOAD_PATH="https://dl.google.com/linux/direct/google-chrome-stable_current_amd64.deb"
}

# $1-text
msg() {
	[ -z "$DISPLAY" ] && echo "$1" ||
	Xdialog --title "$APPTITLE" --infobox "$1" 0 0 10000
}

# $1-text, returns true/false
yesno() {
	local p
	if [ -z "$DISPLAY" ]; then
		printf "%s\nType [yes] to continue: " "$1"
		read p
		case "$p" in
			[Yy][Ee][Ss]) return 0
		esac
		return 1
	else
		Xdialog --title "$APPTITLE" --yesno "$1" 0 0
	fi
}

# $1-text
splash() {
	if [ -z "$DISPLAY" ]; then
		echo "$1" 
	else
		if [ "$1" ]; then
			[ $SPID ] && kill $SPID
			Xdialog --title "$APPTITLE" --no-buttons --infobox "$1" 0 0 10000000 &
			SPID=$!
		else
			[ $SPID ] && kill $SPID
			SPID=""
		fi
	fi
}


download_chrome() {
	wget -q "${FF_DOWNLOAD_PATH}"
}


package_chrome() {
	splash "$(eval echo $(gettext 'Making google-chrome package, the package will be stored in $HOME'))"
	mkdir pkg.$$; cd pkg.$$
	
	# extract
	mkdir -p usr/share/pixmaps
	undeb ../google-chrome-stable_current_amd64.deb ./
	
	# setup symlinks, etc
	cp opt/google/chrome/product_logo_48.png usr/share/pixmaps/google-chrome.png
	rm usr/share/applications/google-chrome.desktop
	   
	# run google-chrome as spot
	# TODO: symlink to program-spot in future versions
	cat << "EOF" >> usr/bin/google-chrome-spot &&
#!/bin/dash
SPOT_HOME=$(awk -F: '$1=="spot" {print $6}' /etc/passwd)
case "$TZ" in
	:*) TZ="${TZ#:}"
	test -L "$TZ" && TZ=$(readlink "$TZ")
	TZ=${TZ#/usr/share/zoneinfo/}
esac
exec /usr/bin/run-as-spot /opt/google/chrome/google-chrome --user-data-dir="$SPOT_HOME/.config/chrome" "$@"
EOF

	rm -f usr/bin/google-chrome-stable
	cat << "EOF" >> usr/bin/google-chrome-stable &&
#!/bin/dash
case "$TZ" in
	:*) TZ="${TZ#:}"
	test -L "$TZ" && TZ=$(readlink "$TZ")
	TZ=${TZ#/usr/share/zoneinfo/}
esac
exec /opt/google/chrome/google-chrome "$@"
EOF

	chmod +x usr/bin/google-chrome-spot usr/bin/google-chrome-stable &&
	
	# desktop file
	cat << "EOF" > usr/share/applications/google-chrome.desktop 
[Desktop Entry]
Version=1.0
Name=Google-Chrome Browser
GenericName=Web Browser
Comment=Google-Chrome
Exec=google-chrome-spot %U
Icon=google-chrome.png
Terminal=false
Type=Application
MimeType=text/html;text/xml;application/xhtml+xml;application/vnd.mozilla.xul+xml;text/mml;x-scheme-handler/http;x-scheme-handler/https;
StartupNotify=false
X-MultipleArgs=false
X-Desktop-File-Install-Version=0.16
Categories=WebBrowser;
Encoding=UTF-8
EOF

	# doinst.sh & desc 
	mkdir install
cat << EOF > install/slack-desc
google-chrome: google-chrome $1 (Web browser)  
google-chrome:  
google-chrome: Official Google-Chrome web browser.
google-chrome: 
google-chrome: 
google-chrome: 
google-chrome: 
google-chrome: 
google-chrome: 
google-chrome: 
google-chrome:  
EOF
	cat << EOF > install/doinst.sh
#!/bin/sh
chown -R root ./opt/google/
chmod 4755 ./opt/google/chrome/chrome-sandbox
# no more aliasing of nss/nspr from seamonkey, we use system libs now
# (SM's one no longer works for chrome now).
#! [ -d ./usr/lib64/ ] && mkdir -p ./usr/lib64 # for making sfs
#ln -s /usr/lib64/seamonkey/*.so ./usr/lib64/
EOF

	# make the pkg
	makepkg -c n -l n $HOME/google-chrome-$1-$ARCH-official.txz > /dev/null 2>&1
}

# $1-version
install_chrome() {
	splash "$(eval echo $(gettext 'Installing Google-Chrome $1...'))"
	removepkg google-chrome
	installpkg $HOME/google-chrome-$1-$ARCH-official.txz
	splash
	msg "$(gettext 'Done.')"
}

download_gtk3() {
	if ! slapt-get --installed | grep -q '^gtk3.*x86_64'; then
		splash "$(gettext "Updating package list, please wait...")"
		slapt-get --update
		splash "$(gettext "Installing GTK+3, please wait...")"
		if ! slapt-get --install gtk3; then
			splash
			msg "$(gettext "Failed to install GTK+3.")"
			exit 1
		fi
	fi
}

#### main
get_config
! yesno "\
$(gettext 'Running this program will download, package, and install the latest Google-Chrome.') 
$(gettext 'If you already have Google-Chrome installed it will be replaced.') 
$(eval echo $(gettext 'The newly created package can be found in $HOME.')) 
$(gettext 'You can can save this packge for later or just delete it.') 
$(gettext 'Are you sure you want to continue?')
" && exit

download_gtk3
splash "$(gettext 'Downloading Google-Chrome, please wait ...')"
mkdir -p $WORKDIR; cd $WORKDIR
if download_chrome; then
	package_chrome $LATEST
	install_chrome $LATEST 
else
	splash
	msg "$(gettext  'Failed to download.')"
fi
cd; rm -rf $WORKDIR
