#!/bin/dash
# jamesbond 2013
# configure hwclock in UTC or in localtime
# 131026 internationalisation by L18L

# std localisation stanza
export TEXTDOMAIN=fatdog
. gettext.sh
# performance tweak - use "C" if there is no localisation
! [ -e $TEXTDOMAINDIR/${LANG%.*}/LC_MESSAGES/$TEXTDOMAIN.mo ] &&
! [ -e $TEXTDOMAINDIR/${LANG%_*}/LC_MESSAGES/$TEXTDOMAIN.mo ] && LANG=C

### config
APPTITLE="$(gettext 'Hardware Clock Configuration')"
HWCLOCKPARM="--localtime" # default
HWCLOCKCONF=/etc/hwclock.conf
[ -e $HWCLOCKCONF ] && . $HWCLOCKCONF # HWCLOCKPARM, HWCLOCKRTC

### main
[ $(id -u) -ne 0 ] && exec gtksu "$APPTITLE" "$0"

DEFAULTLOCAL=off DEFAULTUTC=off
case $HWCLOCKPARM in
	*utc) DEFAULTUTC=on ;;
	*localtime) DEFAULTLOCAL=on ;;
esac

if HWCLOCKPARM=$(Xdialog --title "$APPTITLE" --no-tags --stdout \
	--radiolist "$(gettext 'Hardware clock keeps timekeeping when your computer is turned off.
	In which timezone do you want to run your hardware clock?')" 0 0 5 \
	utc "UTC $(gettext '(Universal Time) - compatible other Linuxes')" $DEFAULTUTC \
	localtime "$(gettext 'Local timezone - compatible with Windows')" $DEFAULTLOCAL); then
	echo "HWCLOCKPARM='--${HWCLOCKPARM}' HWCLOCKRTC='$HWCLOCKRTC'" > $HWCLOCKCONF
	hwclock --systohc --$HWCLOCKPARM $HWCLOCKRTC
	Xdialog --title "$APPTITLE" --infobox "$(eval_gettext 'Hardware clock now configured to run in $HWCLOCKPARM.')" 0 0 10000
else
	Xdialog --title "$(gettext 'Cancelled')" --infobox "$(gettext 'Nothing was changed.')" 0 0 10000
fi
