#!/bin/ash
# remove an existing user, and delete the home directory unless told not to
# jamesbond 2012
#
# $1-existing user name, $2-"keep" - keep home folder

### configuration
STD_GROUPS="users tty audio video lp lpadmin"	# list of groups to include the new user in
HOME_DIR=/home/$1

### main
if [ $(id -u) -ne 0 ]; then
	echo "Must run as root."
	exit
fi
if [ $# -eq 0 ]; then
	echo "Usage: rmuser.sh user [keep]"
	exit
fi

# remove users from the all groups
for p in $(awk -F: '{print $1}' /etc/group); do
	busybox delgroup $1 $p 2> /dev/null
done
busybox deluser $1

if [ "$2" != "keep" ]; then
	rm -rf $HOME_DIR
fi