#!/bin/dash
# This file is sourced, not run.

# Sane terminal helpers.
#
# Copyright (C) step 2017
# License: GNU GPL Version 2 or higher.
#

### Exec in a terminal with sane colors (and other) properties.
# "Sane" refers to colors that work well with dialog(1).
# Supported terminals: urxvt (defaultterm), xterm.
# Input: $@ what to exec with $TERM_SANE_EXEC; TERM_SANE_* env-vars.
# Usage: [TERM_SANE_EXEC=exec] [TERM_SANE_TERM=defaultterm] [TERM_SANE_PROFILE=DIALOG_DEFAULT] exec_with_sane_terminal dialog ...
# Test: net-setup.sh <&- &
exec_with_sane_terminal() {
  #: test; TERM_SANE_TERM=xterm TERM_SANE_PROFILE=XTERM
  local a t _exec _term _profile
  _exec="${TERM_SANE_EXEC:-exec}"
  _term="${TERM_SANE_TERM:-defaultterm}"
  _profile="${TERM_SANE_PROFILE:-DIALOG_DEFAULT}"
  set -- -e "$@"
  case "$_term" in
    *xterm*) t="xterm*" ;;
    *) t="URxvt." ;;
  esac
  # Set properties. First property in takes precedence.
  # fixups {{{
  # See note [a].
  set -- -xrm "xterm*cursorColor: " "$@"
  # }}}
  # other properties {{{
  # See notes [a].
  for a in \
  "${t}fading: 0" "${t}perl-ext-common: " \
  "${t}background: black" "${t}foreground: white" \
  "${t}cursorBlink: false" \
  ; do set -- -xrm "$a" "$@"; done
  # }}}
  case "$_profile" in
    ANSI ) #{{{
      # See ref [1].
      for a in \
      "${t}cursorColor: blue3" "${t}cursorColor2: red" \
      "${t}color0: black" "${t}color1: red3" "${t}color2: green3" "${t}color3: yellow3" "${t}color4: blue3" "${t}color5: magenta3" "${t}color6: cyan3" "${t}color7: antiquewhite" \
      "${t}color8: grey25" "${t}color9: red" "${t}color10: green" "${t}color11: yellow" "${t}color12: blue" "${t}color13: magenta" "${t}color14: cyan" "${t}color15: white" \
      ; do set -- -xrm "$a" "$@"; done
      ;; #}}}
    DIALOG_DEFAULT ) #{{{
      # See ref [0], [4].
      for a in \
      "${t}cursorColor: blue2" "${t}cursorColor2: red" \
      "${t}color0: black" "${t}color1: red3" "${t}color2: green3" "${t}color3: yellow3" "${t}color4: blue2" "${t}color5: magenta3" "${t}color6: cyan3" "${t}color7: gray90" \
      "${t}color8: grey50" "${t}color9: red" "${t}color10: green" "${t}color11: yellow" "${t}color12: #5c5cff" "${t}color13: magenta" "${t}color14: cyan" "${t}color15: white" \
      ; do set -- -xrm "$a" "$@"; done
      ;; #}}}
    URXVT_DEFAULT ) #{{{
      # See refs [0], [4].
      for a in \
      "${t}cursorColor: blue2" "${t}cursorColor2: red" \
      "${t}color0: black" "${t}color1: red3" "${t}color2: green3" "${t}color3: yellow3" "${t}color4: blue3" "${t}color5: magenta3" "${t}color6: cyan3" "${t}color7: antiquewhite" \
      "${t}color8: grey30" "${t}color9: red" "${t}color10: green" "${t}color11: yellow" "${t}color12: blue" "${t}color13: magenta" "${t}color14: cyan" "${t}color15: white" \
      ; do set -- -xrm "$a" "$@"; done
      ;; #}}}
    VGA ) #{{{
      # See ref [2].
      for a in \
      "${t}cursorColor: #0000A8" "${t}cursorColor2: #FF0054" \
      "${t}color0: #000000" "${t}color1: #A80000" "${t}color2: #00A800" "${t}color3: #A8A800" "${t}color4: #0000A8" "${t}color5: #A800A8" "${t}color6: #00A8A8" "${t}color7: #A8A8A8" \
      "${t}.color8: #000054" "${t}color9: #FF0054" "${t}color10: #00FF54" "${t}color11: #FFFF54" "${t}color12: #0000FF" "${t}color13: #FF00FF" "${t}color14: #00FFFF" "${t}color15: #FFFFFF" \
      ; do set -- -xrm "$a" "$@"; done
      ;; #}}}
    XTERM_DEFAULT ) #{{{
      # See ref [0], [4].
      for a in \
      "${t}cursorColor: blue2" "${t}cursorColor2: red" \
      "${t}color0: black" "${t}color1: red3" "${t}color2: green3" "${t}color3: yellow3" "${t}color4: blue3" "${t}color5: magenta3" "${t}color6: cyan3" "${t}color7: gray90" \
      "${t}color8: grey25" "${t}color9: red" "${t}color10: green" "${t}color11: yellow" "${t}color12: blue" "${t}color13: magenta" "${t}color14: cyan" "${t}color15: white" \
      ; do set -- -xrm "$a" "$@"; done
      ;; #}}}
  esac
  $_exec $_term "$@"
}

# Notes {{{
# [a] xterm doesn't support resources cursorColor2, fading, and perl-ext-common.
# }}}
# Refs {{{
# [0] https://wiki.archlinux.org/index.php/Rxvt-unicode "By default urxvt uses the same colors"
# [1] man 1 urxvt 9.22 COLOURS AND GRAPHICS "list of ANSI colours"
# [2] man 7 urxvt 9.22 "values that are supposed to resemble a VGA screen"
# [3] https://en.wikipedia.org/wiki/X11_color_names#Numbered_variants
# [4] src/init.C line ~160
# }}}
