
# Efficient way to structure a translation table.
# Must use POSIX shell syntax -- no bashisms

i18n_table() # {{{1
{
# Notes for translators:
# 1. Apparently the standard xgettext utility doesn't know how to extract
#    strings from calls to 'gettext -es'. Therefore the .pot template was
#    generated with usr/share/doc/nls/<this_project>/make-pot.sh.
# 2. From this point on:
#    A. Never use \n **inside** a msgstr. For yad and gtkdialog you can replace
#    \n with \r.
#    B. However, always **end** your msgstr with \n.
#    C. Replace trailing spaces (hex 20) with non-breaking spaces (hex A0 UTF-8 encoded as \xc2\x0a).
#
# SPECIFIC INSTRUCTIONS FOR THIS SCRIPT:
# 3. i18_WinSize sets width and height of the main window. If necessary your
#    translation can change the width to make room for longer strings.
#
  {
    read i18n_AppTitle
    read i18n_WinSize
    read i18n_GtksuTitle
    read i18n_ProgressTitle
    read i18n_invalid_credentials
    read i18n_NAME
    read i18n_SHARE
    read i18n_credentials_help
    read i18n_p2_User_name
    read i18n_p2_Password
    read i18n_Skip
    read i18n_Skip_ttip
    read i18n_Go_to_next_share_for_server
    read i18n_Jump
    read i18n_Jump_ttip
    read i18n_Leave
    read i18n_Leave_ttip
    read i18n_p2_Show
    read i18n_p2_Show_ttip
    read i18n_p2_Hide
    read i18n_p2_Hide_ttip
    read i18n_p2_Enter_credentials
    read i18n_VARS
    read i18n_unckecked_row
    read i18n_unckecked_rows
    read i18n_A_share_could_not_be_mounted
    read i18n_Folder_could_appear_empty
    read i18n_Double_click_customize_entry
    read i18n_Review_mount_icons
    read i18n_Mp_icn_hlp1
    read i18n_Mp_icn_hlp2
    read i18n_Mp_icn_hlp3
    read i18n_Dclick_to_edit
    read i18n_Click_to_accept_default
    read i18n_Load
    read i18n_Save_result
    read i18n_File_save_error
    read i18n_Load_result
    read i18n_File_load_error
    # options dialog
    read i18n_network_configuration_error
    read i18n_Options # title
    read i18n_Shares  # group
    read i18n_Scan    # group
    read i18n_Scan_445
    read i18n_Connect_SMB1
    read i18n_Use_utf8
    read i18n_Scan_another_subnet
    read i18n_Port_scan_timeout
    read i18n_Subnet
    read i18n_Enter_subnet
    read i18n_New_port_scan_timeout
    read i18n_export_You_are_not_connected
    read i18n_Discovery_Stats
    read i18n_Discovery_note
    read i18n_Server
    read i18n_IP
    read i18n_SharesNum
    read i18n_Stats
    read i18n_Stats_ttip
    read i18n_Scanning_Network
    read i18n_Scanning_Networks
    read i18n_p2_Firewalled
    read i18n_p2_this_firewall_enabled
    read i18n_Gathering_Authentications
    read i18n_mount_it
    read i18n_unmount_it
    read i18n_found_no_servers
    read i18n_found_no_shares
    read i18n_final_ask_save_file
    read i18n_share_icon_incomplete
    read i18n_share_icons_incomplete
    read i18n_share_icon_created
    read i18n_share_icons_created
    read i18n_final_usage
    # Exclusive to scripts/part2
    read i18n_p2_TitleMount
    read i18n_p2_GtksuTitleMount
    read i18n_p2_Could_not_mount
    read i18n_p2_Hints
    read i18n_p2_Hints_1
    read i18n_p2_TitleUnmount
    read i18n_p2_GtksuTitleUnmount
    read i18n_p2_Could_not_unmount
    # For AppInfo.xml.tpl
    read i18n_SUMMARY
    read i18n_UMOUNT
    read i18n_EDITCONF
    # For /usr/share/applications/FILE.desktop
    read i18n_desktop_Name
    read i18n_desktop_Comment
    # SMB ports
    read i18n_p2_port_139
    read i18n_p2_port_445
  } << EOF
  $(gettext -es -- \
  "SMB Browser\n" \
  "620x400\n" \
  "Scan for SMB Shares\n" \
  "Progress Log\n" \
  "Unknown user name or invalid password. Try again.\n" \
  "%sThe server named <b>%s</b> (%s) seems to need a password. Do you want to store one?\n" \
  "%sThe share named <b>%s</b> for server <b>%s</b> (%s) seems to need a password. Do you want to store one?\n" \
  "* Leave user name and password empty to be requested on each mount\r* Set user name <b>guest</b> to try password-less access on supporting servers\n" \
  "_User name\n" \
  "_Password\n" \
  "_Skip\n" \
  "Don't attach this share.\n" \
  "Go to the next share for this server.\n" \
  "_Jump\n" \
  "Go to the next server skipping all remaining shares for this server.\n" \
  "_Leave\n" \
  "Leave here and go to review your choices.\n" \
  "S_how\n" \
  "Show passwords.\n" \
  "_Hide\n" \
  "Hide passwords.\n" \
  "Please enter your credentials to access share <b>%s</b> on server <b>%s</b> (%s)\n" \
  "Attach\tError\tNetworkResource\tMountOptions\tServerName\tFolderName\tServerIP\tUserName\tUserPassword\n" \
  "%d unchecked row.\n" \
  "%d unchecked rows.\n" \
  "Some password-protected share could not be mounted and is not attached.\n" \
  "Enter valid credentials in the Username and Password cells then check <b>Attach</b>.\n" \
  "Invalid credentials make an attached share appear empty because it can't be accessed.\n" \
  "Review mount icons\n" \
  "For each attached share a mount icon will be created with the listed parameters:\n" \
  ". You can double-click any cell to change a parameter\n" \
  ". You can also add arbitrary shares by right-clicking and selecting Add\n" \
  ". Uncheck <b>Attach</b> to prevent creating an icon for a share\n" \
  "Click OK to create mount icons for the attached shares.\n" \
  "_Load\n" \
  "Save scan results to file.\n" \
  "File save error %d\n" \
  "Load scan results from file.\n" \
  "File load error %d\n" \
  \
  "network configuration error\n" \
  "Options\n" \
  "Shares\n" \
  "Scan\n" \
  "Scan on port 445 instead of port 139.\n" \
  "Connect with SMB version 1 by default.\n" \
  "Use the utf-8 character set.\n" \
  "Specify a different subnet to scan...\rcurrent value: %s\n" \
  "Specify the timeout for the port scan...\rcurrent value: %s\n" \
  "Subnet:\n" \
  "Enter a subnet to scan, just the first 3 octets.\rThe local subnet pool is: %s\n" \
  "New timeout for the port scan:\n" \
  \
  "The computer is not connected to a network.\rA connection is needed to find network shares.\n" \
  "Discovery Statistics\n" \
  "Discovery results depend on the credentials (user name and password) you entered.\n" \
  "Server\n" \
  "IP\n" \
  "Discovered\n" \
  "S_tats\n" \
  "View discovery statistics...\n" \
  "Scanning Network...\n" \
  "Scanning Networks...\n" \
  "Firewall enabled\n" \
  "The system firewall is enabled\n" \
  "Gathering Authentications...\n" \
  "mount it\n" \
  "unmount it\n" \
  "No SMB servers found on the network.\n" \
  "No visible shares found for the credentials you entered.\n" \
  "Save network scan results to a text file that you can tweak and reload. Save '%s'?\n" \
  "Failed creating a local app to connect to the share.  It is recommended to delete the halfway icon.\n" \
  "Failed creating %d apps to connect to the shares below. It is recommended to delete halfway icons.\n" \
  "Network share icon created.\n" \
  "%d network share icons created.\n" \
  "Click icon to mount its share. Right-click icon for more options. Remember to unmount when not in use. Optionally move unmounted icon to another folder but don't duplicate.\n" \
  \
  "Mount SMB Share\n" \
  "Mount SMB Share %s\n" \
  "Could not mount shared folder <b>%s</b>.\n" \
  "<b>Hint:</b> Right-click the share icon, edit mount settings and retry.\r. The share could be password-protected.\r. The Username and Password fields could be wrong.\r. The server name or IP address could have changed.\n" \
  "\r. Some mount options (-o) could be invalid or malformed.\n" \
  "Unmount SMB Share\n" \
  "Unmount SMB Share %s\n" \
  "Could not unmount shared folder <b>%s</b>.\rClose all files open on the shared folder and try again.\n" \
  \
  "SMB share\n" \
  "Unmount %s\n" \
  "Edit Mount Settings...\n" \
  \
  "SMB Browser.\n" \
  "Discover and mount SMB shares in ROX-Filer.\n" \
  \
  "Make sure that TCP out port 139 is open.\n" \
  "Some servers may also use port 445.\n" \
  )
EOF
}

