# This script is sourced not run

# Coded for a POSIX shell.

# All functions in this file are shared among the SMB Browser RoxApp and the
# Share RoxApps.  Share RoxApps both embed and load this file.
# Loading provides upgrades to the Share RoxApps when the Browser RoxApp
# is updated. Embedding provides a fallback when loading fails, that is, for a
# portable Share RoxApp that was detached from a full Fatdog64 system.

# A Share RoxApp also gets initialized variables from the Browser RoxApp:
# connection info and translations (i18n variables named *_p2_ and *_export_).

# FALLBACK-BEGIN # embedded into Share RoxApps
# --------------------------------------------------------------------- {{{1}}}
init_app1() # {{{1
{
  set +f
  PARAMS="$@"
  cd "$(dirname "$0")"
  APPDIR=$(pwd -P)
}

init_app2() # {{{1 Out $YAD_OPTIONS $YAD_BORDERS
{
  YAD_BORDERS=10
  export YAD_OPTIONS="$YAD_OPTIONS --title='$YAD_TITLE' --window-icon='$APPDIR/.DirIcon' --buttons-layout=center --borders=$YAD_BORDERS"
}

get_subnets() # {{{1
# IP4 only for now
{
  ifconfig |
  awk '/inet[ ]/ && !/127\.0\.0\.1/ { split($2, A, /[:.]/); print A[1]"."A[2]"."A[3] }'
}

is_firewalled() # {{{1 In/Out $_IS_FIREWALLED (0|1)
{
  local gtksu
  if ! [ "$_IS_FIREWALLED" ]; then
    [ $(id -u) -ne 0 ] && gtksu="gtksu eztables"
    $gtksu service eztables status |
      grep -qm1 running && _IS_FIREWALLED=1 || _IS_FIREWALLED=0
  fi
  [ 1 = "$_IS_FIREWALLED" ] # cached
}

set_Username_Password() # In/Out {{{1 for part2 only
# In/Out: $Username, $Password
{
  local hidepassword=1 button_showhide IFS="$(printf '\b')" ret=2 focus notice
  [ -n "$Username" ] && focus="--focus-field=2"
  [ "$hidepassword" ] &&
    button_showhide="$i18n_p2_Show!$ICON_SHOW!$i18n_p2_Show_ttip" ||
    button_showhide="$i18n_p2_Hide!$ICON_HIDE!$i18n_p2_Hide_ttip"
  is_firewalled && notice="   <b><span bgcolor=\"yellow\">  $i18n_p2_Firewalled  </span></b>"
  while [ 2 = $ret ]; do
    set -- $(yad \
      --title="$i18n_p2_TitleMount" \
      --on-top --center --text=$(printf "$i18n_p2_Enter_credentials" "$Share" "$Server" "$IP") \
      --form --separator="$IFS" $focus \
      $notice \
      --field="$i18n_p2_User_name": "$Username" \
      --field="$i18n_p2_Password":${hidepassword:+H} "$Password" \
      --button=gtk-ok:0 --button=gtk-cancel:1 --button="$button_showhide:2" \
      --button="gtk-help:defaultbrowser /usr/share/doc/faqs/smb-browser.html" \
      && ret=$? || ret=$?; echo "${IFS}$ret") # keep! for shell option +e
    for ret; do :; done
    if [ 2 = $ret ]; then [ "$hidepassword" ] && unset hidepassword || hidepassword=1 ; fi
    if [ 0 = $ret -o 2 = $ret ]; then
      Username=$1 Password=$2
    else
      break
    fi
  done
  return $ret
}

exit_no_subnets() # {{{1
{
  yad --center --on-top --button=gtk-ok --timeout=8 --text="$i18n_export_You_are_not_connected" || true
  exit
}

# --------------------------------------------------------------------- {{{1}}}
# FALLBACK-END
