%%textdomain fatdoghelp
![Fatdog](fatdog64.png)
# Networking - Using Network Setup

The primary way to connect to a network is to use the Network Tool ![Connect](wpa_gui.png), which is documented [here](Networking.md).

---------------------------------

Network Setup can be used to connect wired and wireless networks in a way that is independent of the Network Tool.

For ease of use and breadth of features most users should prefer the Network Tool over Network Setup, but Network Setup still provides some unique features. Most prominently, it has the ability to set up network connections without running Xorg. Network Setup uses text-based dialogs that work for both the system console (no Xorg), and a terminal window (Xorg).

From the system console, start Network Setup with the command network-setup.sh. For Xorg start the Network Setup applet from the Control Panel Network tab.

To navigate the dialog use the Up and Down arrow keys to hightlight a menu entry, the Enter key to activate it, the Tab and Shift Tab keys to cycle across the input fields and the buttons, and the Esc key to go back one level.

## Connect to Wireless Networks with Network Setup

You can configure a static or automatic (DHCP) address for your wireless (wlan0) adapter.

The concepts and actions that are involved are similar to those for Network Tool, where they are explained in more detail.

To add a new profile and connect to the network:

### Step 1

![NetSetupMain](network-setup-main.png)

![NetSetupChooseWifi](network-setup-choose-wifi-interface.png)

In the main window select Configure IP address then choose the interface adapter to configure, wlan0 in this example, but the actual name may be different for your computer.

### Step 2

Select Auto-configure using DHCP, and acknowledge the confirmation window. If you prefer to configure a fixed IP address select Use static IP instead (see Configuring a Static Address with Network Setup below for further instructions).

![NetSetupConfigureIP](network-setup-configure-ip.png)

![NetSetupWifiConfigured](network-setup-wifi-configured.png)

### Step 3

Go Back to the main window.

### Step 4

In the main window select Configure access profile then choose the same interface adapter, wlan0.

### Step 5

Select New profile from existing networks. This will scan for available wireless networks.

![NetSetupNewProfileWifi](network-setup-new-profile-from-wifi-networks.png)

![NetSetupWifiScanner](network-setup-wifi-scanner.png)


### Step 6

Select the name (SSID) of your wireless access point, "homewifi" in this example.

### Step 7

The SSID and Security fields are automatically filled in. Normally you don't need to change them.

![NetSetupPassword](network-setup-enter-password.png)

### Step 8

Fill in the password for "homewifi" and press OK.

### Step 9

Go back to the main window.

### Step 10

In the main window select Activate settings now then choose the same interface adapter, wlan0.

### Step 11

Select the name of the profile you want to activate. For wireless it is the SSID name.

![NetSetupActivate](network-setup-activate-interface.png)

### Tips:

Network Setup saves configurations under directory /etc/network-setup


---------------------------------


## Configuring a Static Address with Network Setup

When you select "Use static IP" in step #2 above you come to this dialog to set a static address.

![NetSetupStaticIP](network-setup-static-ip.png)

### Step 1

Enter IP address, Netmask and Default Gateway.

### Step 2

Enter DNS server 1 and optionally DNS server 2. The default values set Google's DNS servers. You may want to replace these with your ISP's DNS server addresses.

### Step 3

Press OK to save the configuration for your interface name.

See also Configuring a Static Address for wireless networks for general information about static addresses.
	Network Setup static IP window


---------------------------------


## Connect to Wired Networks with Network Setup

To add a new profile and connect to a wired network follow the instructions given for wireless networks, but select a wired interface (eth0 in this example). You will not need to scan for networks or to enter an access password.

![NetSetupChooseWired](network-setup-choose-wired-interface.png)
	
	
## Disable or Enable Network Tool

In the main window you can disable or enable the Network Tool services. This applies at the next reboot and every reboot after, until the Network Tool is enabled again from Network Setup.

## Troubleshooting Menu

"Reset udev persistent net rules" clears the interface names that Linux automatically assigns to network adapters. Then Fatdog64 will restart wired adapter names from "eth0" and wireless adapters from "wlan0". If you use this entry you will need to configure all static IP addresses again.

![NetSetupTroubleshooting](network-setup-troubleshooting.png)
