%%textdomain fatdoghelp
![ ](fatdog64.png)
# Boot Options

# Advanced Parameters

%%nopot yes
[savefile](boot-options-savefile.md) - [key](boot-options-key.md) - [net](boot-options-net.md) base

## basesfs
 
%%nopot no
This parameter tells Fatdog64 where to find the basesfs file (e.g. fd64-800.sfs).

It can be specified in three different ways:

		basesfs=option:location
This instructs Fatdog64 to load the basesfs from the specified **location**

		basesfs=none 
This instructs Fatdog64 not to use any basesfs at at all.

Booting with no basesfs will run a console-only minimal system based on busybox (Bulldog Linux).


		basesfs=ask 
This instructs Fatdog64 to ask for the basesfs during boot time.

At boot time, you can either specify **none** or **location**.

---

For details on **location**, please refer to the **savefile here**.

They are identical.

**option** can be one of the following; they provide the same functionality as base2ram parameter (and take precedence over it).

 - Nothing (no option given)
 - direct - which is ignored, for compatibility only (in case you misidentify this option from the savefile layer)
 - ram - load the basesfs to RAM (same as base2ram=yes)
 - expand - load the basesfs to RAM, and expand it (make it run the fastest - same as base2ram=expand)

%%nopot yes
## base2ram=yes 

%%nopot no
This instructs Fatdog to load the basesfs into RAM.

By default, basesfs is contained within the initrd itself ("humongous initrd") and is automatically loaded to RAM, but if you use an external basesfs, it is not, except when this parameter is used. As of Fatdog64 710, this option is deprecated.

%%nopot yes
## base2ram=expand 

%%nopot no
This instructs Fatdog to uncompress the basesfs into RAM.

This will work whether the basesfs is internal (in initrd) or external. Since it uses RAM to keep the uncompressed version of the basesfs, using this option implies base2ram=yes. As of Fatdog64 710, this option is deprecated.

%%nopot yes
## extrasfs 

%%nopot no
This parameter tells Fatdog64 to pre-load additional SFS files right before the system starts. These SFS files are loaded after the the union filesystem has been setup, and after /etc/fstab has been processed. SFS files loaded this way are not kept in permanent record. However, they can be un-loaded just like others using System SFS Loader.

You can load multiple SFS-es here, separating them by commas (spaces are not allowed in the names):

    extrasfs=location,location,location,etc

For details on location, please refer to the **savefile** option. They are identical, although for now, only **device**, **label**, **uuid**, **local** and **usb** are supported. The rest are not (they will be implemented if there is popular demand for them). Alternately, you can specify just a fully qualified path name to a device that has been mounted earlier in /etc/fstab. "/mnt/home" is popular. The path can be anything; it can even point to a raw device (/dev/sdb) if relevant.

Location can also be prefixed with **ram** which means that the given SFS will be loaded to RAM (and thus will not hog the device it is loaded from). For consistency, you can also prefix it with **direct**, although it will do nothing.

Example: extrasfs=/mnt/home/s1.sfs,ram:/mnt/home/s2.sfs,device:sdb:/path/to/s3.sfs,/dev/sdc

The last specification will load the entire partition of /dev/sdc as an SFS.


%%nopot yes
## mergeinitrd{n}

%%nopot no
(From Fatdog 720 onwards). The actual name of the parameter is **mergeinitrd1**, **mergeinitrd2**, **mergeinitrd3**, etc. Each word specifies the location of an additional initrd which will be loaded and merged during the boot process, before the basesfs is processed. The main motivation for this function is to have a small initrd, merge it with a huge-initrd and obtain the basesfs from that huge-initrd without having to do anything extra. Or it can be used to extend or enhance Fatdog's main initrd with additional / extra functions that reside in an external/optional initrd.

The parameter is specified as follows: **mergeinitrd{n}=[wait:]location:path[:crypt]:[init-func]**. For the details on location, please refer to **basesfs** parameter. This parameter only supports location types of **device**, **label**, **uuid**, **local** and **usb**; it does not support cifs, nbd, or others.

**path** gives the actual path to the initrd to be merged, on the given device.

**wait** is an optional parameter that specifies that the system should give you a prompt to plugin a removable device (e.g. USB flash drive) before attempting to load the initrd from that device. This enables you to boot a system without the removable device plugged in, and only plug it at the time you want to load the additional initrd, and then remove it again.

**crypt** is an optional parameter that specifies that the device that holds the initrd is encrypted. You can use either "crypt" or "dmcrypt".

**init-func** is an optional parameter that specifies the initialisation function that will be executed as soon as the merge is done. This function is sourced by the main init function, and therefore cannot fail and cannot exist. It must return once the initialisation is done.

The complete list of options for mergeinitrd{n} is:

    mergeinitrd{n}=[wait:]device:dev:path[:crypt]:[init-func]
    mergeinitrd{n}=[wait:]label:label:path[:crypt]:[init-func]
    mergeinitrd{n}=[wait:]uuid:uuid:path[:crypt]:[init-func]
    mergeinitrd{n}=[wait:]local:path[:crypt]:[init-func]
    mergeinitrd{n}=[wait:]usb:path[:crypt]:[init-func]
    mergeinitrd{n}=ask

If you specify **ask**, you will be asked to enter the details at boot time.


%%nopot yes
## withlvm 

%%nopot no
This tells Fatdog to enable its LVM support.

When LVM is enabled, Fatdog64 will recognise LVM partitions and can load savefile / basesfs from these partitions.

%%nopot yes
## withmdadm 
 
%%nopot no
This tells Fatdog to enable its mdadm (Linux software RAID) support.

When mdadm is enabled, Fatdog64 will recognise mdadm partitions and can load savefile / basesfs from these partitions.

Note: mdadm is for **Linux software RAID**, *not for FakeRAID*. At the time of writing FakeRAID is not supported at boot time, although they can be accessed after boot by installing the **dmraid** package.

%%nopot yes
## posixovl
 
%%nopot no
This tells Fatdog to use [posixovl](https://sourceforge.net/projects/posixovl/) 
when loading non-POSIX filesystems for use as savedir or savefile. 
Currently this affects only CIFS and FAT/VFAT filesystems. 
When this is specified, you can use CIFS or FAT filesystems for a save-directory with all the features you expect from a POSIX filesystem (file ownership, file-mode, symlinks, hardlinks, etc).

Notes: Due to limitations of FAT and CIFS, you must always use the RAM layer when using these as save-directories. 
This is enforced by Fatdog. 
Also, since posixovl runs in user-space, don't expect great performance. 
You don't need posixovl to use NTFS as your save-directory, as recent versions of ntfs-3g included in Fatdog already support POSIX features directly on top of NTFS.



---

%%nopot yes
[savefile](boot-options-savefile.md) - [key](boot-options-key.md) - [net](boot-options-net.md) base

%%nopot no

---

[Advanced and Troubleshooting Parameters](boot-options-trouble.md)
