%%textdomain fatdoghelp
![ ](fatdog64.png)
# Boot Options

## Fatdog64 Parameters

%%nopot yes
### waitdev

%%nopot no
wait for device - this instructs Fatdog64 to delay the boot process by a few seconds, so that save devices have time to settle and be ready - so that they can be accessed (and the savefile can be read off them).

By default, Fatdog64 boots as fast as it can. You need this option if your save device is not recognised during boot - the usual symptom is that you have a savefile but Fatdog does not use it. This mostly happens for USB devices.

My computer for example requires at least 3 seconds for flash drives to be recognised; delays of up to 5 seconds are not uncommon.
Some slower devices may need an even longer time.

The syntax is: **waitdev=n** where n is the number of seconds to wait.

On Fatdog64 720 onward, the syntax is **waitdev=n[:n[:n[...]]]** where each number represents the number of seconds to wait, for each "wait point". In 720, there are two "wait points", one is at early boot before basesfs/savefile is loaded (this is the same as the original waitdev), and the second one is in rc.sysinit, before pkeys is processed and before Xorg is loaded. The two wait points are independent; you can specify one without the other. For example, if you only want to wait for 3 seconds at the second wait point, you can specify it like this: **waitdev=:5** (the colon is not a typo).


%%nopot yes
### search=n

%%nopot no
Control searching of possible savefiles in subdirectories.

This parameter tells the boot process "at which subdirectory level, in a given path, searching for savefiles is to end". If **n** is not specified it defaults to **1**.  Fatdog will search for **fd64save*** (or whatever filename you specify in the **savefile**  parameter) starting in the directory you have specified (default is root directory).

If, for example, you want it to search in subdirectories up to **3**-levels deep, specify **search=3** instead. If more than one savefile matching the pattern if found, they will be listed and you will be asked to choose the one to use.

Search is only performed when **savefile** specifies a location of **local** or **usb**. Other location types do not perform searching regardless of this parameter.

We generally recommend not to depend on this parameter as searching slows down the boot process; it is always better to specify the exact location of the savefile (using device / uuid / label locations) if possible.

%%nopot yes
### blacklist

%%nopot no
Prevent named list of modules (drivers) from being loaded. Use this if the system cannot start-up due to suspected bad modules.

The syntax is: **blacklist=module1,module2,module3*** and so on.

Note: separate module names by comma, and there is no space in between.

%%nopot yes
### pfix=xorgwizard

%%nopot no
Launch xorgwizard automatically to select the driver, screen resolution, and bit depth before you start the desktop.

This option only has effect if you choose autologin or console login; it is ignored when the graphical login manager is in effect.

%%nopot yes
### pfix=nox

%%nopot no
Do not automatically start X server and graphical desktop after login.

You can always start it manually later by running the command **xwin** from console.

%%nopot yes
### pkeys

%%nopot no
Set the keyboard layout and console font you want to use for the Linux console.

Default is US keyboard (pkeys=us), with whatever font the system has.

You can change that here. Only restricted options are available:

- de, be, br, dk, es, fi, fr, it, no, se, pt --- these will use UTF-8 font.
- cz, hu, pl, ro, sk, croat, slovene --- these will use ISO-8859-2 font.

For example: Specify **pkeys=br** to enable Brazilian keyboard.
Note that once you go to the graphical desktop, you need to set it separately using **Keyboard Localization** from the Control Panel.

%%nopot yes
### dofsck

%%nopot no
Perform a filesystem check on filesystems that will be used by the savefile and basesfs, before they are used. It will check both the physical partitions as well as the savefile. Only ext2/3/4 and FAT filesystems will be checked.

---

[Linux Kernel Parameters](boot-options-linux.md) 
