%%textdomain fatdoghelp
![ ](fatdog64.png)
# Boot Options

## Linux Kernel Parameters

%%nopot yes
### nomodeset

%%nopot no
This is a kernel boot option that tells the kernel not to enable kernel mode setting (KMS).
Video support is usually a combination of a drm kernel driver and an Xorg driver working together.
KMS is used with Intel, Nouveau, and Radeon kernel modules. KMS is required for Intel and Nouveau, and optional for Radeon (although with different features).

If you want to use the vesa Xorg driver, and you have hardware that uses the Intel, Nouveau, or Radeon kernel modules, you may need to boot with nomodeset, or blacklist the matching module, or just delete the module. The modules will be found in /lib/modules/<kernel-version>/kernel/drivers/gpu/drm/.

See also [here.](screen.md)

%%nopot yes
### video

%%nopot no
This kernel boot option tells the kernel KMS driver what resolution and/or frequency to use. For this to work, KMS must not be disabled (see above). The format of the option is as follows:
		video=conn:res[M][R][-bpp][@refresh][i][m][eDd] 
This option can be specified multiple times, one for each different connection name - so you can have one setting for VGA, one for HDMI, etc.

- **conn** means the connection name, which depends on how your monitor is connected to the system. Listed are some common connection names; their names are self-explanatory:
		VGA (VGA connector)
		DVI-I (DVI connector, supporting both digital and analog - rare
		DVI-D (DVI connector, digital only)
		DVI-A (DVI connector, analog only - rare)
		composite (composite video)
		s-video (S-video output)
		LVDS (Laptop panel)
		component (component video output)
		displayport (Mac display)
		HDMI-A (the first HDMI port)
		HDMI-B (the second HDMI port)
		TV (TV output)

- **res** stands for the resolution. It is specified as **width**x**height**, in pixels (e.g. 800x600).


- **M**, if specified, means that the display timing frequency will be computed using the
[VESA CVT](http://en.wikipedia.org/wiki/Coordinated_Video_Timings) standard, otherwise a hard-coded timing table will be used.


- **R**, if specified, means that a "reduced blanking" display timing frequency will be used. This is useful for digital displays (LVDS, DVI or HDMI). Otherwise standard timing will be used.


- **-bpp** stands for bit-per-pixel, that is, the bit-depth of the display, that is, the number of colours to be used. If not specified, the driver will choose the highest supported one. Common values are:

	-32 (32-bit per pixel: 16million colours)
	-24 (24-bit per pixel: 16million colours)
	-16 (16-bit per pixel: 64thousand colours) - you're unlike to use this nowadays
	-15 (15-bit per pixel: 32thousand colours) - you're unlike to use this nowadays
	-8 (8-bit per pixel: 256 colours) - you're unlike to use this nowadays
	-4 (4-bit per pixel: 16 colours) - you're unlike to use this nowadays

- **@refresh** specifies display refresh rate (also known as the vertical frequency refresh rate). Usually @60 or @59 for digital displays, you can specify others for analog / CRT monitors. If not specified the highest supported rate will be used.

- **i**, if specified, means to use interlaced mode for calculation. This only makes sense for analog / CRT monitors.

- **m**, if specified, means add some margins to the display timing calcuation (add 1.8% margin).

- **e**, if specified, means to enable the port (even if no device/monitor is detected).

- **D**, if specified, means to enable the port (even if no device/monitor is detected) and use the Digital interface.

- **d**, if specified, means to disable the port (even if there is a monitor attached there).

Note: This is a generic parameter used to set framebuffer display resolution. It can also be used for non-KMS drivers too.
That is not discussed here because it is irrelevant; for further reference see [Linux Kernel Framebuffer Documentation](http://www.kernel.org/doc/Documentation/fb/).

%%nopot yes
### pci=nocrs

%%nopot no
Discard pci ACPI information. May fix boot problems.

%%nopot yes
### pci=noacpi

%%nopot no
Do not use ACPI for PCI bus management. May fix boot problems.

%%nopot yes
### acpi=off

%%nopot no
Do not use ACPI. Note that modern systems probably will not boot if this parameter is specified.

%%nopot yes
### loglevel=n

%%nopot no
Verbosity of kernel boot-up message. n is from 0 to 7.
**loglevel=0** means don't print anything, **loglevel=7** means print every single detail. Default is n=3.

More Linux kernel parameters can be found [here](http://www.kernel.org/doc/Documentation/kernel-parameters.txt) or [here](http://www.mjmwired.net/kernel/Documentation/kernel-parameters.txt).

---

[Fatdog64 Parameters](boot-options-fd.md)

