%%textdomain fatdoghelp
![ ](fatdog64.png)
# Boot Options

# Advanced Parameters

%%nopot yes
[savefile](boot-options-savefile.md) - [key](boot-options-key.md) - net - [base](boot-options-base.md)

## net

%%nopot no
This parameter tells Fatdog64 to start the network s early as possible, during boot time, so that it can be used to load basesfs and savefile from network locations (cifs and nbd).

It also automatically enables the **coldplug** parameter.
It can be specified in two different ways:

		net=type:device-settings:ip-address-settings
This instructs Fatdog64 to load the basesfs from the specified **location**.

		basesfs=ask 
This instructs Fatdog64 to ask for the savefile during boot time.
At boot time, you can either specify **none** or **location**.


The supported **types** are as follows:

- wired -- for a wired network
- wpa -- for a wireless network using WPA security
- wpa2 -- for a wireless network using WPA2 security

The **device-settings** depends on which type is used.

- For a wired network, you only need to specify the network device name e.g. eth0.

Example:
		wired:eth0

- for wpa or wpa2 networks, you need to specify the ssid:password:device.

Example:
		wpa2:myhome:xyzzy:wlan0
Note: the password you specify here is visible in /proc/cmdline after you boot. If you don't like this, you should use **net=ask** and key it in at boot time instead.

The **ip-address-settings** determines whether you want to use dhcp or a static IP address.

It is optional, if you don't specify it, dhcp will be used.

- For dhcp, you only need to specify dhcp.

 Example:
		net=wired:eth0:dhcp

- For a static IP address, you need to specify ip:ip-address:netmask:gateway:dns
"gateway" and "DNS" are optional.

Example:
		net=wired:eth0:ip:192.168.1.2:255.255.255.0:192.168.1.1:192.168.1.1

---

%%nopot yes
[savefile](boot-options-savefile.md) - [key](boot-options-key.md) - net - [base](boot-options-base.md)

%%nopot no

---

[Advanced and Troubleshooting Parameters](boot-options-trouble.md)
