%%textdomain fatdoghelp
![ ](fatdog64.png)
# Filesystem structure

Fatdog64 utilizes [AUFS](http://aufs.sourceforge.net/aufs.html) to form a stackable filesystem, which enables viewing multiple different filesystem as if they were one, big, merged virtual filesystem.

The Fatdog64 main file system is compressed into a single read-only file using [Squashfs](http://en.wikipedia.org/wiki/SquashFS).
During boot, the read-only main file system (fd64-8xx.sfs) is mounted at /aufs/pup_ro.

At first shutdown you will be asked if you want to create a savefile (e.g. fd64save.ext4).
During boot that file, which is really a read-write file system, is mounted at /aufs/pup_save.
If you don't have a savefile yet a RAM layer (tmpfs) will be used and that will be mounted at /aufs/pup_rw. Then the init script uses AUFS to merge the main read-only file system with the read-write savefile, and mounts this new virtual file system on / (the root filesystem).

Using the System SFS Loader, found under System in the Control Panel, you can add other SFS files (file extension .sfs) to the virtual file system.
This can be done at any time.
For example, fd64-devx\_800.sfs, which contains gcc, static libraries, headers, kernel source and everything else you need to compile applications, could be added into our virtual file system.
Just place the fd64-devx_800.sfs file at the root of the partition that contains our savefile (/mnt/home), or use the SFS Manager (also in the Control Panel) to automatically download and save it, then use the System SFS Loader to add it.
That's it.

In the System SFS Loader, answer "yes" when asked if you want to keep the chosen layer configuration after reboot.
These extra SFS files are mounted at /aufs/pup_roX (X is a number starting from 10 for historical reasons), and are merged into the rest of the virtual file system which gets mounted at /.

Typical file system mounting:

![ ](fs-layers.png)

The layers or branches (pup\_rw - pup\_roX) are listed in the order of priority. Files on the upper layers take priority than those in the lower layers.

For example, if a file exists with the same name and in the same location in the file system tree, in the pup_rw layer and in the pup \_ro4 layer, the file in the pup\_rw layer will be the one that is visible.

When a file is deleted from the virtual file system that really exists in the pup\_ro  (read-only) layer, a .wh.xxx file is written in the pup\_rw layer that is only visible in that layer.
This file serves as a flag to AUFS that the corresponding file should not be visible in the virtual file system mounted on /.

So what are the advantages to all this? Many, here's a list:

* The original system files are always available in /aufs/pup_ro.

* Changes to the file system can easily be spotted in /aufs/pup_rw or /aufs/pup_save

* The pup_save layer can be easily encrypted. This is an option when you create your save file.

* You can create many save files, which effectively gives you many installs.

* Back-ups only require you to make a copy of one file (fd64save.ext4).

* Since the file systems are loop back mounted, you can install on non-Linux partitions (FAT, NTFS)


To create another save file you need to boot RAM only.
If booting from CD, you would use the boot option fatdog **savefile=none**.
If booting from grub you can edit your **menu.lst** or hit the **e** key when the grub screen pops up.
Then add **savefile=none** to the kernel line.
Then you'll boot up without a save file: the pup\_rw layer will be in RAM.

When you shutdown you will be asked if you want to create a new save file.
When you reboot and multiple 'fd64save' files are detected you will be asked which one you want to use.
If you encrypted your save file, you will also be asked for your password.

## Special note for Puppy Linux veterans

If you have been using Puppy Linux for a while, you will already know the stackable filesystem structure. The Fatdog64 filesystem may look similar (except that /initrd is renamed to /aufs), but the differences are deeper than that.
Here are some of them:

**1.** In Puppy Linux, all extra SFS files will be loaded **under** the main filesystem (puppy_xxx.sfs - mounted at /initrd/pup_ro2). Thus in Puppy Linux it is impossible to use extra SFS files to replace an existing file in the main filesystem. In Fatdog64, all extra SFS files will be loaded **above** the main filesystem, so it is possible to deliver an SFS to upgrade the system libraries located in the main filesystem.

**2.** In Puppy Linux, the lowest layer is indeterminate. This is because an extra SFS is added at the bottom of the stack - the most recently added extra SFS will be at the bottom of the stack. In Fatdog64, the lowest layer is always /aufs/pup_init. This is a read-only copy of the original boot filesystem contained in initrd.

**3.** In Puppy Linux, /initrd/pup_rw is always the top-most writable layer. This writable layer can either point to the RAM layer or point to the savefile. If the RAM layer is used, the savefile is mounted at /initrd/pup_ro1 instead. In Fatdog64, the topmost writable layer is either /aufs/pup_rw (when the RAM layer is used) or /aufs/pup_save. In Fatdog64, /aufs/pup_rw always points to the RAM layer, and /aufs/pup_save always points to the savefile.

**4.** In Puppy Linux, the mount point names are effectively hardcoded - their use is entrenched in so many scripts that it is almost impossible (or arduous at least) to change them without causing any breakage. In Fatdog64, this is not the case. You should always consult /etc/BOOTSTATE to see which layers are being used, and the actual mountpoint names. In fact, do not even hardcode the location /etc/BOOTSTATE; instead depend on the environment variable $BOOTSTATE_PATH to get to that file.


In both Fatdog64 and Puppy Linux (when running with AUFS instead of unionfs), if you want to know the exact ordering of the layers, the best way to do it by consulting the contents of /sys/fs/aufs/si_xxxxxx/br[0-9]* for the / filesystem (where xxxxx is a random number generated by AUFS; you can get this code by looking at the mount properties for / ).


