%%textdomain fatdoghelp
![Fatdog](fatdog64.png)
# Installation Options

[Click here for UEFI (Windows 8 and 10) installation instructions.](uefi-harddrive.md)

## Guided Installation

Fatdog64 comes with an installer for BIOS-based systems capable of installing to hard drives and flash drives.

It provides a guided step-by-step method:

### 1. Choose which device to install to:

- You can choose a hard drive or a flash drive.

- You can choose to format the chosen partition (= existing data loss) or leave it as is.

- You can also run gparted to modify the chosen partition.

- For a flash drive, you can install to a partition (e.g. sdb1) or to the entire flash drive, in "superfloppy" mode (e.g. sdb).

We recommend you install to a partition.

### 2. Choose whether you want to install a boot loader:

- Install boot loader to Master Boot Record (MBR): unsafe, can cause an existing operating system to stop booting, but Fatdog64 will boot)

- Install boot loader to the partition where Fatdog64 is installed: (usually safe if Fatdog64 is the only operating system in the partition. If you do this on a partition that has an existing operating system in it, that operating system may stop booting)

- Use existing Operating System boot loader: Only works for Windows 2000/XP/Vista/7. For Linux, please see below on manual installation note.

- Do not install boot loader



Note that Fatdog64 will not boot unless you install or reconfigure a boot loader. If you choose not to install a boot loader with the installer, you must do so manually yourself.

If you choose to install a boot loader (to MBR or partition), the partition that contains Fatdog64 will also be made the "active" one and the one that will boot. If you have other operating systems installed in other partitions, they may no longer boot.

### 3. Choose an installation source:

- From a Fatdog64 CD/DVD

- From an ISO file downloaded from the Fatdog64 distribution

---

Fatdog64 installer supports installing to VFAT, FAT16, FAT32 (also known as MSDOS partitions, usually used for flash drives), ext2/ext3/ext4 (Linux partitions, usually used on hard drives), and NTFS partitions (Windows partitions).

**Note: **Fatdog64 Installer is experimental code.

It may cause data loss, or cause other installed operating systems to stop booting. Backup your data before you use it. **Use at your own risk.**


## Manual Installation

Manual installation is good for upgrading an already installed system.

All you need to do is copy two files, vmlinuz and initrd, from a Fatdog CD/DVD to where you previously installed Fatdog64, and overwrite them.

**Note**: Grub Legacy and Grub4dos are **VERY** slow loading files from ext4, You may not have noticed this with a typical 10MB kernel/initrd, but with Fatdog64 that will be closer to 400MB. If you want to use one of these bootloaders, you should put Fatdog64's kernel/initrd on an ext3 partition.

### Manual boot loader configuration

If you already have a boot loader and don't want to bork it, you may choose to install Fatdog64 manually.

Simply copy the two files above somewhere in your disk, adjust your boot loader configuration (grub.cfg / menu.lst / extlinux.conf / whatever) to load Fatdog64's vmlinuz kernel and initrd.

Some examples:

Example for menu.lst (GRUB and GRUB4DOS)
		title Fatdog64
		rootnoverify (hd0,0)
		kernel /vmlinuz
		initrd /initrd

Example syslinux.cfg (for syslinux, extlinux, pxelinux)
		label Fatdog64
		kernel vmlinuz
		initrd initrd

That (hd0,0) refers to GRUB-style naming of the device and partition.

If you're not sure what it means, Google is your friend.


## Supported media / operating modes

Fatdog64 can be installed in several types of media and has a few operating modes.

### Live CD/DVD

You don't have to install Fatdog64 to use it. You can just use the Fatdog64 CD/DVD as is.

When you shutdown, you will be asked where to save your "session" (ie your changes, configuration settings, browser bookmarks, etc).
You can choose to save to a flash drive, or to your hard drive.
This session is saved in a file referred as the "savefile":  its actual name can vary but it's usually called fd64save.ext4.

Next time you want to start-up the computer, just put in the CD (also plug-in the flash drive if you put your savefile there) before you power-up your computer, and Fatdog will find and load-up the savefile - your environment will be just the same as it was when you shutdown previously.

Note: Fatdog64 loads completely into RAM. 
This means that after Fatdog64 completes the boot process, you can take out the CD/DVD and put something else there (e.g to listen to music, watch movies).
Note that because of this, you need to have enough RAM to load the entire copy of Fatdog64 into memory --- a minimum of 1GB is probably needed.

### Harddrive

You can install Fatdog64 to your hard drive.
The installation method used by Fatdog64 is known as "frugal install", where instead of occupying a dedicated partition, it can use *any existing* partition, sharing it with existing data and/or an operating system.
All the installation does is to copy two files: vmlinuz and initrd, and configure the boot loader if you ask it to.

Operation in Harddrive mode is identical to a Live CD, except that you don't always have to carry the CD with you.
The savefile can be in the harddrive or can be on a flash drive.

You can also modify the kernel command line parameters (please refer to [Boot Options](boot-options.md)) to specify exactly where your savefile is so that Fatdog64 does not waste time looking for your savefile.

### Flash drive

Also known as thumbdrive, usb stick.

[For booting on UEFI (Windows 8 and 10) hardware click here](uefi-harddrive.md).

Flash drive installation operates exactly like Harddrive installation.
The flash drive needs to be formatted with VFAT/FAT16/FAT32 (MSDOS filesystem) or NTFS (Windows filesystem) or one of the Linux filesystems (ext2/ext3/ext4) before it can be used to install/boot Fatdog64.
Other formats are not supported.

The flash drive can be formatted just like a harddisk (i.e. multiple partitions), or it can be operated like one big storage device (called "superfloppy" mode in Puppy Linux terms).
If you use the installer, you can see the difference as follows: a flash drive formatted like  a harddisk will have partitions (e.g. if your flash drive is identified as sdb, then it will have a partition named sdb1 (and possibly sdb2, sdb3 and so on), whereas a flash drive prepared in superfloppy mode does not have partitions.

Fatdog64 supports both, but sometimes your BIOS (your computer firmware that controls your computer before any operating system is loaded) may not.
You can try whichever one to see if it works.

You can use Fatdog64 installer to change your flash drive between harddisk mode or superfloppy mode (warning: data loss).
If you want to use standard harddisk partitioning, use Gparted ("Modify Partitions" from the installer) to create partitions in your flash drive if they do not exist and then format that partition (usually Gparted will do that for you too).

If you want to use superfloppy mode, choose the "disk" device of your flash drive (e.g. sdb, not sdb1) and then format it.

One special concern with flash drives is that they have a limited number of writes that can be done on them, usually around 10,000 for cheap ones. After this number of writes have been done, they will start to fail in an unpredictable manner.

While you may think you will not do 10,000 writes, the operating system writes many times behind your back (especially if you use journaling filesystems like ext3/ext4 or NTFS).

### Session saving control

Fatdog64 addresses this by using the RAM layer - writes are stored into memory, and only once every 30 minutes or so (configurable) the changes will actually be flushed and written to the flash drive. This helps to extend the life of the flash drive considerably.

It also makes operations faster, as a flash drive is a slow device when it comes to writing stuff to it. In this way, you will only notice the delay during the periodic saving.

This is all good stuff, but like everything in the world, it has a downside: if you lose power, you can lose up to 30 minutes (or whatever period you set) of 
your work.

If this is not acceptable, don't use a flash drive; get a portable harddrive instead.

This is a feature with all savefile operations - not only flash drives, but also to regular drives and network drives.

The periodic saving can also be disabled, making you fully in charge of whether or when to save changes.

(You can also save by clicking the big red "Save" button on the desktop.)
You can choose not to save the session at all if you wish - whatever you did during your session will be thrown away and you'll start fresh when you use your computer the next time.

Unlike Puppy Linux, Fatdog64 does not try to automatically enable the RAM layer feature for flash drives.
You need to specifically enable RAM layer (please refer to [Boot Options](boot-options-savefile.md).

### Multisession DVD+RW / DVD+R / DVD-R

Running Fatdog from a Multisession DVD+RW is just like running Fatdog from a Live CD/DVD, except that the session can be saved directly to your DVD+RW --- not a flash drive or hard drive.
During shutdown, your changes will be compressed and written as an SFS file on the disc, and it will be loaded again the next time you reboot.
Note that all the session data is loaded into RAM, so you need to have quite a bit of it. Once the system boots up, you can take out the DVD+RW - just like Live CD/DVD. You will be reminded to put it back in at shutdown time.

When the disc is full, all you need to do is burn another copy of Fatdog64 on a new optical disc, then use this disc when prompted to insert the disc. Fatdog64 will save your old session as well as the new session on the new disc.

Multisession is enabled by passing the "multi" parameter on the kernel command line parameter.

Note 1: The following optical disc types have been tested and known to work: DVD+RW, DVD+R, DVD-R. CDs are not supported.

Note 2: Multisession DVD+RW is an oxymoron. DVD+RW in fact does not have nor support "multisession" as it is defined for CD or DVD-R. But the result of running in this mode is similar to running a traditional multisession, so we keep this term.

Note 3: At this stage, support for multisession is still rough. There is no warning on whether the disc is full, and when the disc is full, you need to manually burn a new copy of Fatdog64 to another disc before saving the session.


## Advanced installation options

These will only be discussed briefly. Starting from Fatdog64 600, the following installation options are available:

### Copy ISO file directly to a flash drive

The Fatdog64 ISO file is an isohybrid image. In addition to burning it to CD/DVD, it can be imaged directly to a flash drive. When done this way, the flash drive will work exactly like a Live CD.

### Savefile encryption

The savefile can be encrypted. This is asked during its creation during initial shutdown. During boot, the system will ask for the password. If the password is wrong the system will continue to boot without the savefile. The cipher used for encryption is AES (in the future it may be configurable.)

### "Underdog" feature

Fatdog can mount and use another existing Linux operating system as part of its own filesystem. In this way, it can use many components of that operating system as they are its own. In Puppy Linux terms, this is called as "underdog" feature. Changes done can either be saved directly to that system, or saved and stored in a separate savefile so that the original operating system is unaffected.

### Remote savefiles

Savefiles can be stored not only in local devices, but also in remote systems, using either CIFS (aka SAMBA / Windows shares), or NBD (network block device).

### Netboot

Fatdog can be directly booted by pxelinux directly from the ISO file, using memdisk.

A simple configuration looks like this:
		pxelinux.cfg/default
    
		default fatdog
		label fatdog
		kernel memdisk
		initrd fatdog64.iso
		append iso raw

Or you can still use the standard netboot options by extracting vmlinuz and initrd and specify them directly without using memdisk.

Fatdog64 only requires these two files to boot. In Puppy Linux terms, Fatdog64's initrd is called a "humongous initrd".

Using memdisk is easy, but using extracted files is more flexible because you can configure the kernel command line to pass instructions to Fatdog64 (which isn't possible when you use memdisk).

### Multisession with harddrive

The Multisession feature is available not only for DVD+RW, but also for harddisk. This way, every session is saved as a separate SFS file (which can be opened and reviewed independently).
Unwanted session files can simply be deleted.

## Unsupported installation options from previous Fatdog64 versions

### Multisession CD

Multisession with CD is not supported.
Systems capable of running Fatdog64 usually comes with DVD writers anyway, so this usually is not a concern.

### Multisession DVD

Multisession with DVD-R/DVD+R/DVD-RW is not supported.
It might work but it is untested.

### Full Install

Full install is where the compressed files from the install CD are expanded and copied to a harddisk, to a dedicated partition.
This is the normal mode of installation for mainstream Linux systems, such as Ubuntu or Fedora.

Fatdog64 does not support this mode of installation.
