%%textdomain fatdoghelp
![ ](fatdog64.png)
# Replacing a kernel module in initrd

## Step 1

Use Rox to find the location of initrd (usually at the root directory where you installed Fatdog64).

## Step 2

Make a backup of this initrd file, in case you make a mistake.

## Step 3

Click the initrd file. The initrd will be extracted into a working folder (somewhere under /tmp)

## Step 4

Inside this folder, there is a file called **kernel-modules.sfs**

## Step 5

Open a terminal session from the folder:

- Make sure no file are selected.

- Right-click

- Choose "Window" menu, then choose "Terminal Here"

## Step 6

From terminal, run the command **unsquashfs kernel-modules.sfs**

## Step 7

You will get a new folder created within, called **squashfs-root**.

## Step 8

Inside this squashfs-root folder, you can find **lib/modules/3.18.7** folder. The version number (3.18.7) may be different for different version of Fatdog64.

## Step 9

Copy the module you have created in the appropriate location inside the above folder.

## Step 10

When done, from terminal, run the command

	depmod -b $(pwd)/squashfs-root -a

This will rebuild the module depedency list.

## Step 11

Delete the original kernel-modules.sfs. Don't worry, we are going to build a new one.

## Step 12

From terminal, run the command 

		mksquashfs squashfs-root kernel-modules.sfs -comp xz

Make sure you do this after deleting the original kernel-modules.sfs.

## Step 13

Now remove the squashfs-directory.

## Step 14

Close your terminal by typing **exit**, we're done.

## Step 15

Last step - do this if you feel you have done everything right - click and launch the **repack-initrd** from Rox.

This will re-build the initrd and delete the working folder.

---

**Note 1:** If you make a mistake, just close the folder and you can restart again. Nothing is changed until you do the last step: repack-initrd

**Note 2:** You can do the operation from terminal or from Rox, but please ensure:

**1.** Use terminal commands for those that explicitly mentions "from terminal, do XXX".

**2.** In terminal, do not "cd" to anywhere else (if you do, please change to the original directory before you execute the commands - the instructions above assume you do not change the directory).

