%%textdomain fatdoghelp
![ ](fatdog64.png)
# Intel Graphics Known Issues

## OpenGL 2.1 and Intel Graphics

From Februrary 2017 onwards, Mesa (the open-source OpenGL library) has dropped OpenGL 2.1 support for certain older and less capable Intel graphic cards.

If you need to run applications that need OpenGL 2.1 (e.g. blender) for these cards, it is possible to retro-fit the the OpenGL 2.1 support.

This is done editing /etc/drirc and adding the following snippets:

```sh
<driconf>
...
    <device driver="i915">
        <application name="Default">
            <option name="stub_occlusion_query" value="true" />
            <option name="fragment_shader" value="true" />
        </application>
    </device>
...
</driconf>
```

----------------------

References:

 * https://www.phoronix.com/scan.php?page=news_item&px=Mesa-i915-OpenGL-2-Drop
 * https://www.phoronix.com/scan.php?page=news_item&px=OpenGL-1.4-i915-Now-Default
 * https://wiki.archlinux.org/index.php/Intel_graphics#OpenGL_2.1_with_i915_driver

## Desktop takes a long time to show up after booting up

On certain machines with old Intel graphic chips, it may take a relatively long time (can be up to a few minutes) for the desktop to show up, after an apparently successful text-mode boot up.

There are many possible causes for this, but one of the most frequent one is because the kernel driver is trying to activate the S-VIDEO interface, which in reality may not even be connected to anything in your machine.

To fix this, you need to tell the kernel to disable S-VIDEO interface. This is done by putting the following boot parameter: **video=SVIDEO-1:d**
in your boot loader entry.

Reference: [https://bugs.freedesktop.org/show_bug.cgi?id=93782](https://bugs.freedesktop.org/show_bug.cgi?id=93782)
