%%textdomain fatdoghelp
![ ](fatdog64.png)
# I'm logged in as root?

Fatdog64 is a 64-bit desktop operating system targeted for home desktop computer owners. It aims to give full control of the home computer to its user, without restriction.

As such, the primary user is "root". The user logs in as root. By default, not even a password is required - the system auto-logs in as root upon boot-up.

Logging in as root offers unparalleled convenience for home users, so it is and always will be the default mode of operation for Fatdog64.

Before you suppose that logging in as root is "unsafe", please ask yourself: "unsafe" from whom?

Remember, this is a home desktop computer we are talking about, not a shared server in a large networked environment.
In this context, logging in as a non-privileged user only protects you from one person - **yourself**  - (i.e. from your own mistakes).
It also protects you from doing exactly one thing: destroying the system.

But consider this:

- restoring the Fatdog operating system is a 5 second job, assuming you have a Fatdog CD/DVD/USB around, and

- logging in as an unprivileged user does not protect you from mistakes that can wipe out your own data.


What is more important and irreplaceable - your data, or the operating system files?

---


### Question

But what about network programs? How about security holes in them? Especially, how do I ensure that whenever I use a web browser / email / chat program / etc (*insert your favorite network program name here*), if there are security holes in them, they won't be able to infect my system?

### Answer

Fatdog answers this question in the same way that Android (yes, that Android) answers the question: ** *Network security should not be equal to local security* **.

In Fatdog, most network programs run as "spot", which is a non-privileged user.
"spot" only has access to a few very limited places.

If there are security holes in that network program that allow a remote attacker to gain access to the system, they will only be able to access stuff which "spot" can access - which is not much.
(Android goes even further - every process, not only network processes, is run by a separate randomised user).

How is this any different from the standard non-privileged user login?

Consider this - let's say you log-in as your regular non-privileged user ("regular" means the user id you use for day-to-day work, so this is the user id that owns your home directory, owns your data, etc) and run network programs as that user too.

This is how typical Linux distros do it.

Now let's assume that there is a security hole in the network program that enables a remote attacker to gain access to your system.
When a remote attacker manages to do this, he/she will gain access as **your regular user id** (because this is the user id used to run the network program, remember?).

What can the remote attacker **not do**? Among other things:

- he/she cannot delete operating system files.

- he/she cannot read certain operating system passwords.

- he/she cannot modify operating system files (e.g. to implant a system-wide keylogger to monitor every user in the system).

Big deal. Lets see what the remote attacker **can do** (among other things):

- he/she can delete **your** data

- he/she can read all of **your** data, including **your passwords, your credit card numbers, your tax returns**, etc

- he/she can modify and install programs executed by you at every startup - such as installing a keylogger to monitor everything **you** type.


Thus - what exactly does logging in as a non-privileged user protect?

What is more important and irreplaceable - your data, or the operating system files?

For further discussions of of why logging in as root is not a problem and is in fact safer than what you think, please visit the following:

- [Fear Not Root](http://igurublog.wordpress.com/2010/01/16/fear-not-root/)

- [Multiuser support in Puppy](http://web.archive.org/web/20080604034010/grafpup.org/news/?page_id=243)


### Question

But a computer, even though it is used in a home context, may have multiple users (e.g. families sharing one computer). How do we ensure that they do not interfere with one another, when each is logging in as root with full access to the system?

### Answer

Fatdog, which was originally derived from Puppy, continues to use the Puppy paradigm for supporting multiple users: By using multiple savefiles (encrypted if necessary).

Every user has his/her own savefile to store the computer state (not only data, but the entire computer state).

Within his/her own savefile, the user runs as root; he/she has the full access of the computer, while safely avoiding stepping on other users' toes.

Switching into another user's personality is accomplished by rebooting the system and choosing another savefile.


### Question

But this does not protect one user from deleting another user's savefile!

### Answer

Surprise !! None of the big branded OSs do, either! That is an illusion.
If you have physical access to the computer, you can always boot from a Live CD (any Live-CD) or Live-USB stick, run as root from there, and do anything you wish, including wiping out the disk of the computer, no matter what OS is installed there (in fact, this is what OS installers do).


### Question

But I heard that Fatdog supports multiuser.

### Answer

Yes. There are several perfectly good reasons for multiuser operation, though not for what is typically claimed (as explained above).

With Fatdog, one can:

- Create additional users

- Auto-login as a user other than the default  "root"

- Run multiple X desktops at the same time, each for different users

- Remote X desktop using SSH X11 forwarding

All these capabilities (except the last one) are accessible through the User Manager in Control Panel.

Note: Fatdog multiuser capability is still considered experimental.

### Question

How to create additional users?

### Answer

**1.** Open Fatdog Control Panel.

**2.** Choose the "System" tab.

**3.** Near the end of the list, there is an icon called "User Manager". Launch it by selecting it and pressing Enter.

**4.** Click "Add".

**5.** Enter the name of the new user. Only use alphabetical characters.

Note that the newly created user is assigned a home directory of "/home/$user" and a default password of "woofwoof".


### Question

How to delete users?

### Answer

**1.** Open Fatdog Control Panel.

**2.** Choose the "System" tab.

**3.** Near the end of the list, there is an icon called "User Manager". Launch it by selecting it and pressing Enter.

**4.** Highlight the user you want to delete.

**5.** Click "Delete".



### Question

How to set it up so that at the next boot I will log in as a particular user instead of root?

### Answer

**1.** Open Fatdog Control Panel.

**2.** Choose the "System" tab.

**3.** Near the end of the list, there is an icon called "User Manager". Launch it by selecting it and pressing Enter.

**4.** Highlight the user you want to use.

**5.** Click "Autologin as user".

When you do this, at the next boot you will be logged in as this (non-privileged) user and boot straight to the desktop.
You will no longer run as root, and many operations that require privileged access will now ask you for the root password.
You can change to logging in automatically as root by following the same process as above, choosing "root" as the user.

Note: The "Autologin as user" button is only available when your log in mode is "autologin" (which is the default, unless you change it).

### Question

How to launch a secondary desktop?

### Answer

**1.** Open Fatdog Control Panel.

**2.** Choose the "System" tab.

**3.** Near the end of the box, there is an icon called "User Manager". Launch it by selecting it and pressing Enter.

**4.** Highlight the user you want to use.

**5.** Click "Launch desktop as user".

When you do this, a new X server with its associated desktop are launched and created.

You can switch between your original desktop and the new desktop using Ctrl-Alt-Fx (where x=4,5,6 etc).
Your original desktop would most likely be associated with Ctrl-Alt-F4, while the new desktop will be at Ctrl-Alt-F5.

You can launch multiple secondary desktops if your computer has the resources to do so, but each desktop must be associated with a different user.

Exit any secondary desktop(s) by choosing "Quit X Server" from the menu, or just press Ctrl-Alt-Backspace.
If you wish, you can also terminate the original desktop and use a secondary desktop exclusively until you shut down the system.



### Question

But the system still auto-logs in. I don't want auto-login - I want the system to ask for a user id and password at every boot.

### Answer

**1.** Open Fatdog Control Panel.

**2.** Choose the "System" tab.

**3.** Near the end of the list, there is an icon called "Login Manager". Launch it by selecting it and pressing Enter.

**4.** Choose the login mode you want; there are three choices:

**41.** Autologin - this is the default log-in mode, the system will log-in automatically at boot. No password is required.

**42.** Graphical - this enables graphical log-in. The system will display a graphical log-in screen and ask for a userid and password.

**43.** Console - this enable console login. The system will display a console log-in screen, and ask for a userid and password.

In any case, when log-in is successful, Fatdog will proceed to run the graphical desktop, even when you enable "console login".
If you want to stay in console mode, please specify the "pfix=nox" boot parameter.

**Note: **If "graphical login" is enabled, "pfix=nox" is ignored and Fatdog will always start the graphical desktop.

**Very Important Note: **Before you enable any of the login modes, make sure you either remember the Fatdog default root password (=woofwoof) or, better yet, change it to your own password.
Otherwise you **will not be able to gain root access ever again** without ditching your savefile.


## Fatdog permissions model

### Permissions

- device nodes permission is controlled by udev; the udev rule file is 
		/etc/udev/rules.d/54-fatdog-permission.rules
- /aufs/devsave and /aufs/devbase are set to **root:users**; permission is 775/002 in /sbin/system-init

- **mount-helper** mounts a drive with this permission: **root:$USER**, permission is 770/007

- /var/run/wpa_supplicant access is set to **GROUP=users**

- The following binaries are setuid: su, gtksu, passwd, Xorg, fusermount and crontab.

### Users must be put into the following groups:

- their own group (necessary - drive-icons-mount-helper sets the gid to the user's gid)

%%nopot yes
- users

%%nopot no
- audio	if they are to access sound (youtube etc)

- video	if they are to access video devices (camera webcam etc)

- tty	if they are to access terminals / command line

- lp/lpadmin if they are to access/manager printers

### Other Notes

- Fatdog uses a homebrew privilege escalation program called gtksu

- gtksu is called whenever an application running in non-privileged mode requires root access

- gtksu asks for the root password, not the user's password
