%%textdomain fatdoghelp
![ ](fatdog64.png)
# Why isn't Fatdog using my savefile?

Usually there are two reasons for that:

1. Fatdog cannot find the device on which the savefile is located.

2. Fatdog cannot find the savefile itself.

**Problem 1** usually happens if the savefile is located in a "slow" device, like a USB flash drive. In this case, Fatdog boots so fast that when the device is finally ready for use, Fatdog has already completed its boot process and has missed the device altogether.

The solution to this is simple: use the [waitdev=n](boot-options-fd.md) boot parameter to slow down Fatdog and tell it to wait  **n** number of seconds before continuing.

Usually 3 or 5 seconds is enough for most devices. Slower devices may need more.

**Problem 2** usually happens if you rename the savefile and/or put the savefile in a sub-directory when you create the savefile.
  
It is important to know that by default, Fatdog only scans for savefiles in the root directories of devices, and then only looks for the default filename of the savefile (without the extension).

The default filename is **fd64save.ext4**, which means that Fatdog will only find savefiles named as **fd64save.ext4, fd64save.3fs, fd64save-old.ext2,  fd64save-backup.sfs**, etc., and only if they are located in the root directory.

## Search

It is possible to tell Fatdog to search deeper into sub-directories using the [**search**](boot-options-fd.md) boot parameter, but this is not recommended as searching is slow.

The better way is to tell Fatdog exactly where your savefile is and what its name is, using the [**savefile**](boot-options-savefile.md) boot parameter.

Doing this stops Fatdog from doing any search at all; instead it will use the given device, directory, and filename as its savefile. (If this fails, it will simply boot without a savefile.)

To make this easier, there is an applet in the Fatdog64 Control Panel > Utilities named Savefile Argument Builder that will walk you through the steps to set up the needed boot parameter correctly.
