%%textdomain fatdoghelp
![ ](fatdog64.png)
# Crashing, tearing or freezing with Nouveau.

Nouveau is a driver for Nvidia graphics cards, created by information gleaned from reverse-engineering. As such, the driver is based on incomplete information or worse. Thus there is a lot of problems with this driver - the newer the cards, the more problem you'd probably get. If you can help it, the recommended solution is to use the proprietary Nvidia graphics driver.

If running proprietary driver is not an option, here are some solutions that you can try, depending on the problem you encounter.

**1)** One of the known outstanding driver is the infamouse "multithread bug". Suffice to say that this causes apps that perform heavy concurrent GPU activities to crash randomly. This happens for example with BibleTime which uses QtWebEngine; if you scroll too fast, it would probably crash. May also happens on Chrome / Chromium browser and derivative.

**Solution**: force the application to use software rendering instead of the GPU, by exporting the environment variable **LIBGL_ALWAYS_SOFTWARE=1**  before launching the app. Please note that this cause the application to slow down.
    More Mesa related environment variables here.

**2)** Screen tearing when watching video.

**Solution**: is to run a composite screen manager ("compton"). Often this is enough to stop tearing, but if it doesn't, compton comes with additional options to configure that. Lookup the --vsync options - you can try whichever one that works. Also lookup the configuration below.

The file /usr/share/X11/xorg.conf.d/20-nouveau.conf contains some configuration workarounds for the nouveau driver. They are commented by default (that is, they are all prefixed by the hash (#) character), which means they are not active. To activate them, you need to remove the hashes.

The configuration comes in blocks or sections. A section starts with "Section" and ends with "EndSection". You must remove (to activate) or add (to de-activate) hashes for a complete section, not only to a part of them.

The file above contains multiple sections, one for each workaround. Each workaround address a different problem. Please ensure that you only activate one of them. If you enable multiple sections, the result will be unpredictable.

The first workaround (the first section in the file) is to address tearing - activate this section, restart X, then run compton, and see if there is any improvement.

The second workaround (the second section in the file) is to address freeze, locks-up, or screen artifacts. Note that enabling this section can actually cause artifacts to become worse, so you need to give it a try.

