%%textdomain fatdoghelp
![ ](fatdog64.png)
# Display Problems

## Background

Fatdog64 by default uses KMS (Kernel Mode Setting), a recent development in the Linux kernel where control of display resolution and bit depth (=number of available colours) are managed inside the kernel instead of by the Xorg graphics driver.

As a consequence of KMS, these things happen:

- The KMS kernel driver will take over the graphics early in the boot process.

- This driver will change the video mode from text mode into its highest-available-resolution graphics mode.

- As such, there is no more text console. It is replaced by framebuffer console.

- More often than not, this framebuffer console will display smaller fonts and provides more rows and columns than a standard text console (80x25).

Not all graphic cards/drivers support KMS. The ones that notably support them are:

- Intel (will not work without KMS)

- Nvidia (**nouveau** driver requires KMS, older **nv** does not support KMS)

- Radeon (will not work without KMS)

Those cards/drivers that do not support KMS will continue to work as they had.

In addition, it is possible to turn off KMS as well.

When KMS is turned off, you have two choices:

- If the driver supports non-KMS mode, you can continue to use that driver

- If the driver does not support non-KMS mode, you will have to use the **vesa** driver.

Note: AMD/ATI/NVidia proprietary drivers do not support KMS at the time of writing, and requires that KMS be turned off.
The installer for these driver packages will do this automatically for you.

## Common Problems

Display drivers, especially for advanced GPUs, are very complex.

Add to that the fact that some GPU vendors are less open than others: people who write open-source drivers often do not have enough information on how the cards behave and end up having to make guesses.

Combine that with card releases: new GPUs (at least new display cards) are released every year, sometimes with only subtle differences in behaviour from the earlier versions.

(You should be surprised that it works at all ☺)

But it does, most of the time. When it doesn't, though, you will see these sorts of problems:

- Blank screen (or white screen, or a uniform-coloured screen of some sort, or stripes,...)

- The screen shows "unsupported frequency" or "mode not supported", or something like that.

- The text displayed on the screen is vanishingly small.

- And others.

Rather than going through all the list of possible problems, here we will list possible solutions you can try if you encounter any of these problems.

### Turning off KMS

In the most extreme cases (especially when you have a blank screen or otherwise odd/unusual patterns), you may want to turn off KMS.

KMS can be turned off by putting [nomodeset](boot-options-linux.md) in the kernel boot parameters (click to see more details).
This will turn off KMS entirely. You can also turn off KMS for a specific driver by putting the driver name in front, e.g. **radeon.nomodeset=1** for the radeon driver.

Note that certain drivers absolutely require KMS in order to work; if you turn off KMS you may not be able to use the optimum resolution settings.
Most recent GPU-specific drivers won't work without KMS, and your best bet is to use the **vesa** driver.

You may want to combine turning off KMS with telling Xorg to use a specific GPU driver and/or resolution, outlined below (xorgwizard).

### Tell KMS to use a specific resolution and frequency

Instead of turning off KMS entirely, you may want to try to tell KMS to use a specific resolution and refresh frequency instead - most probably lower than the default one chosen by KMS.
This is useful in cases where your monitor gives out a message that the resolution/frequency chosen by the video card is too high.

Resolution and frequency can be set by using [video](boot-options-linux.md) options (click to see more details).

### Make the console text bigger

If the display is right but it's just that the text on the console is too small to see (this is possible if you use a high-resolution monitor with small physical dimensions), you can use a larger font to make the screen more intelligible.

This isn't usually required as most people don't work on the console directly (most people use the graphical desktop and use the terminal emulators (e.g. xterm / urxvt) inside the graphical desktop), but it may be useful if for some reason you can't get the graphical desktop to start and you're troubleshooting it.

Fatdog64 comes with a size 16x32 Terminus font, called **big** and **bbig** (which stands for "bold and big to make it easier to remember).
To make use of either of these fonts, all you need to do is type this at the console: **setfont big** or **setfont bbig**.

Note: You **must** use the **setfont** command at the linux console, not from the terminal emulator on your graphical desktop.

### Tell Xorg to use a specific driver and resolution

So far what has been discussed explains what can be done to improve the situation at the console.
The graphical desktop (managed by Xorg) has its own settings.
Unless these settings are changed, Xorg by default will automatically load the most suitable GPU driver, then choose the highest supported resolution, bit depth and refresh frequency (just like KMS).

Usually this is what you want, but in case it is not, you can override the automatic settings by running the command **xorgwizard**.
This command allows override of the driver, resolution and bit depth (but not frequency - Xorg will still choose the highest supported frequency given the other parameters).

This command can be run from the console or from within a terminal emulator in the graphical desktop.

We recommend that you run it from the console because then you have the option of testing the driver / resolution / bit-depth.

If you run it from a terminal emulator, you can still have the settings you want, but you can't validate that your chosen settings are right.

These settings are stored in /usr/share/X11/xorg.conf.d/20-gpudriver.conf; if you want to revert to the automatic default settings, just remove this file.

Note: **xorgwizard** indicates which drivers require KMS.
If you disable KMS these drivers won't work.
Your best bet in that case would be to use the **vesa** driver (Generic video driver).

### Tell Xorg to display a larger font

The **setfont** command does not work within the graphical environment (it will screw up your screen instead).

Changing the font size (or font family, for that matter) for the terminal emulator depends on which terminal emulator you use.
For urxvt, the default terminal emulator included in fatdog, create a file called **.Xdefaults** in your home directory and put the command **URxvt.font:xft:mono:pixelsize=14:autohint=true** inside it. Change "14" to whatever size you want, in pixels.

Changing font sizes used by other applications is similarly done through the interfaces or configurations used by them; and this is dependent and different from one application to another.

If you want to change the font size for **all applications** though, the best way to do that is by changing the so-called "Global Font Size". This setting is stored in a file called **.Xresources** (located in your home directory), in a line that starts with **Xft.dpi**.
You can edit this manually and then re-start the X server, or you can use the convenient GUI to change that.

This GUI is accessible from **Control Panel → Desktop → Set Global Font Size**.

It gives you the option to change the size from 54 to 108 (the default is 78).
If you need to set values beyond this range, edit the file manually.

## Useful links about KMS

Here are some links about KMS. Please note that while they are useful as a reference and for background information, not all of the commands discussed there will be directly applicable to Fatdog64.

* [Debian KMS documentation](http://wiki.debian.org/KernelModesetting)
* [Arch Linux KMS documentation](https://wiki.archlinux.org/index.php/Kernel_mode_setting)
* [Freedesktop Nouveau KMS documentation](http://nouveau.freedesktop.org/wiki)
* [Freedesktop Nouveau KMS documentation](http://nouveau.freedesktop.org/wiki/KernelModeSetting)
* [ModeDB - details on the video kernel parameter](http://cgit.freedesktop.org/nouveau/linux-2.6/tree/Documentation/fb/modedb.txt)
* [Older version of ModeDB](http://www.kernel.org/doc/Documentation/fb/modedb.txt) only applicable for non-KMS systems
