%%textdomain fatdoghelp
# Booting with secure boot.
![ ](fatdog64.png)

This document describes booting Fatdog64 from a USB flash drive on a computer with UEFI and secure boot enabled.

All Windows 8 and 10 computers come with secure boot enabled by default.
Secure boot can be disabled if you like in UEFI setup, and Windows will still boot normally.

At the time of this writing the UEFI implementations vary a lot.
Some are easy to configure, some are not.
Some only accept keys that are added though the UEFI set up menu.
Some are really just broken and won't recognize the keys that are added.
Fortunately these are few and hopefully soon to be fixed.

## Step 1

![x](sb1-pic.jpg) 

For most systems pressing F2 when the computer starts to boot will take you to the UEFI set up menu.
Plug in your flash drive that has Fatdog64 installed, turn on the computer and press the F2 key to enter UEFI set up.

Go to the boot tab and move your USB drive to the top of the boot list so that the computer will try to boot from it first.
Exit set up and save your changes. (Usually F10).

On some UEFI implementations you won't have this option, but you will have an option to manually add a boot option. Some have both.
If you need to manually add a boot option, you'll need to browse to /EFI/boot/bootx64.efi on the USB drive.

---

## Step 2

![x](sb2-pic.jpg)

When the computer reboots you should see a screen like this if it booted off the flash drive with secure boot enabled. 

Use the cursor keys to navigate and the enter key to select an option.
You will need to select 'Enroll key from disk' and press enter.

---

## Step 3

![x](sb3-pic.jpg)

Select the device/partition that contains the key and press enter.

It should be the one with 'USB' in it.
In the example above that would be the line just under Exit.

---

## Step 4

![x](sb4-pic.jpg)

Select the 'keys' folder and press enter.

If you don't see a 'keys' folder you probably selected the wrong partition: Select 'Return to filesystem list' and select a different partition.


---

## Step 5

![x](sb5-pic.jpg)

Select 'fatdog64.cer'. This is the Fatdog64 key.

---

## Step 6

![x](sb6-pic.jpg)

The Next screen should look like the image above.
Press the zero key and then enter.

---

## Step 7

![x](sb7-pic.jpg)

On the Next screen press **y** and **enter**.

---

## Step 8

After that you can power off or press Ctrl-Alt-Del to reboot.

Now that the keys are installed you won't be asked for them again.

If for some reason you want to remove the Fatdog64 key, you can delete all the added keys (MOKs) by booting to the UEFI shell from rEFInd and type **dmpstore -d MokList**

**Note:** On a Dell 14z with a 3rd generation I5, the boot would hang after the Grub2 boot selection. For this laptop I disabled secure boot then followed the UEFI hard drive install instructions. Then I re-enabled secure boot and it would boot fine from the hard drive install.


