%%textdomain fatdoghelp
![ ](fatdog64.png)
# File Sharing

There are a few ways to share files with other computers using Fatdog64. They are:

- FTP -- File transfer protocol.
- HTTP -- Web server.
- Samba -- aka SMB, server message block. (This is what Windows uses.)

## FTP

FTP is a good choice if you want to move just single files, not whole folders.
Files must be moved one at a time with FTP, so if you want to do a folder it's best to zip the folder up into one file.

### Server

To start the FTP server go to Control Panel, click on the System tab, and then Manage Servers and Services.
Click on ftpd and then click Start to run the service.
Click enable if you want the ftpd server to run at each boot.

### Clients

To connect from another computer you'll need the IP address of the computer running the FTP server.
Open a terminal and type **ifconfig**, it will look something like this:

		# ifconfig
		lo Link encap:Local Loopback
		inet addr:127.0.0.1 Mask:255.0.0.0
		inet6 addr: ::1/128 Scope:Host
		UP LOOPBACK RUNNING MTU:65536 Metric:1
		RX packets:7289 errors:0 dropped:0 overruns:0 frame:0
		TX packets:7289 errors:0 dropped:0 overruns:0 carrier:0
		collisions:0 txqueuelen:0
		RX bytes:1465218 (1.3 MiB) TX bytes:1465218 (1.3 MiB)

		wlan0 Link encap:Ethernet HWaddr 00:1f:1f:4a:d2:ba
		inet addr:192.168.254.42 Bcast:192.168.0.255 Mask:255.255.255.0
		inet6 addr: fe80::21f:1fff:fe4a:d2ba/64 Scope:Link
		inet6 addr: fd00:788d:f7cf:5b82:21f:1fff:fe4a:d2ba/64 Scope:Global
		UP BROADCAST RUNNING MULTICAST MTU:1500 Metric:1
		RX packets:28698 errors:0 dropped:0 overruns:0 frame:0
		TX packets:14257 errors:0 dropped:0 overruns:0 carrier:0
		collisions:0 txqueuelen:1000
		RX bytes:12594214 (12.0 MiB) TX bytes:2168000 (2.0 MiB)
		#

In this example our IP address is 192.168.254.42.
The other piece of information we need is a login name and password.
To login as root the default password is woofwoof.
When you made your save file, you where given the opportunity to change it.

To change the root password, open a terminal and type:
		passwd
You'll be prompted for a new password.
Then from the other computer open Firefox and in the address box type:
		ftp://192.168.254.42
That's for the example above; substitute your IP address.
You'll be prompted for a user name and password.

You can also connect using gFTP, which is found under Network in the main menu.

---

You can make this available over the internet too.

To do that you'll need to log in to your router and forward port 21 to the IP address of the computer running the FTP server.

## HTTP web server

Http can be a good choice if you want others to be able to download files, but not to upload.

To start the web server go to Control Panel, click on the System tab, and then Manage Servers and Services.
Click on civetweb and then click Start to run the service.

Click enable if you want the http server to run at each boot.

The Civetweb web server forks itself to run as user webuser.

The server's root is located at /var/lib/www.

Files or links placed there will be visible to users of the web server.
To connect open a web browser and enter your IP address.

The configuration file for the server is located at /etc/civetweb.conf.

---

You can make this available over the internet too.

To do that you'll need to log in to your router and forward port 80 to the IP address of the computer running the HTTP server.

---

Note: You can also run civetweb as a "user" server. 

Open terminal and type:
		civetweb
It will then serve the files from the current directory.

To stop it, just press Ctrl-C.

## Samba

If you want to share files with other computers on your local network, including Windows computers, this is the way to go.

### Server

To start the Samba server go to Control Panel, click on the System tab, and then Manage Servers and Services.

Click on samba and then click Start to run the service. Click enable if you want the Samba server to run at each boot.
This will share your Downloads folder as user spot.
 
### Clients

To connect from another computer running **Fatdog64**, open the Shared folder on the desktop and click on Scan.
This will create icons for the shared folders found on your network.
Then click on those icons to mount the shared folder, right click to unmount.

From **Windows** go to network neighborhood/places. You might have to click refresh a few times for it to show up.

Clients connecting to Fatdog64 will only be able to write files in folders that user spot has permission.

