%%textdomain fatdoghelp
![Fatdog](fatdog64.png)
# Installing / Removing Fatdog64 on a flash drive for UEFI and BIOS booting.

## Installing

Note 1: If you only want to boot on computers with BIOS then use the Fatdog64 installer found in the Control Panel under Utilities.

Note 2: The method given below will create a read-only filesystem for the boot files. You cannot modify any boot configuration (isolinux.cfg or grub.cfg). It will also completely erase your flash drive. If you don't like this limitation or prefer a more flexible solution for **UEFI-only** booting, please refer to this [alternative installation method](uefi-flashdrive2.md). 


The Fatdog64 iso file is a dual hybrid iso file. To install it to a USB flash drive, all you have to do is dd the file on to it.
Keep in mind that all files on the flash drive will be destroyed.

The flash drive will have two partition tables on it, so Gparted may not handle adding or modifying partitions correctly.
You can use Gparted to remove the Fatdog64 installation from the flash drive.

Please read **all** of the following steps carefully **before** actually doing anything:

### Step 1

Plug in the flash drive you want to use. When it appears on the desktop, note it's device name. For example 'sdb'.

### Step 2

**In the directory that contains the Fatdog64 iso file** open a terminal and type this:
		dd if=./<Name of iso file> \
		of=/dev/<Flash drive device name> \
		bs=4M
Replace <"Name of iso file"> with the real name of the iso file and replace <"Flash drive device name"> with your flash drive's device name from step 1.

The 'if' stands for **i**nput file, the 'of' stands for **o**utput file, and 'bs' stands for block size. The './' means to look in the current directory.

For example if I wanted to dd the Fatdog64-620.iso file on to my flash drive which is identified as sdb,
I would do this:
		dd if=./Fatdog64-620.iso of=/dev/sdb bs=4M
**Make sure that you have the correct device name for you flash drive. If you use the wrong one you could erase you hard drive!**

Some flash drives may show sdb and sdb1 icons on your desktop, maybe more partitions.

For your device name, use the device name without a number.

### Step 3

If your flash drive was bigger than 256MB you can add another partition to use the remaining space for storage.

Gparted will have problems with this; fdisk can do it if you're careful not to overlap your new partition.
Better yet, you can use the fix-usb.sh script to do it for you.

In the terminal type:
		fix-usb.sh /dev/<Flash drive device name>		
Then follow the instructions fix-usb.sh gives you.

*Note:* The fix-usb.sh script is also in the root of the iso in case you're using another Linux distribution.

### Step 4

If you have any doubt about what you're doing **stop now** before you start anything!

---

## Removing Fatdog64 Installation on USB Flashdrive

A USB flashdrive on which the Fatdog.iso has been written following the steps above cannot be re-partitioned with Gparted anymore because Fatdog's hybrid partitions (combining ISO partition, GPT and MBR partitions) confuse Gparted, regardless of whether it is treated with fix-usb.sh or not.

It will boot, it will work, and it will work very well with Linux on BIOS and UEFI systems, but you cannot re-partition it again with Gparted because it thinks that the flashdrive has invalid partitions.

If you ever need to re-partition the flash drive again, you need to be aware of two things:

a) Doing so will delete all data on the flash drive, so please back up your data first.

b) It will remove the Fatdog installation permanently.

And to do this, in a terminal, just do "dd if=/dev/zero of=/dev/<flash-drive-device-name> bs=1M count=1". 

After doing this Gparted will regard your flash drive as completely empty and will offer to create a new MS-DOS partition table - which you should accept.

**Make sure that you have the correct device name for your flash drive. If you use the wrong one you could erase your hard drive!**




