%%textdomain fatdoghelp
![ ](fatdog64.png)
# Hard drive (frugal) installation of Fatdog64 on a computer with UEFI and secure boot.

**Please read this entire process before doing anything.**

This document describes installing Fatdog64 on a computer with UEFI, with or without secure boot. All Windows 8 and newer computers come with secure boot enabled by default.

First you should make sure Fatdog64 boots and works well on your computer. This can be done by booting from a CD/DVD you burned after downloading the iso or by making a [flash drive](uefi-flashdrive.md) bootable.

If your computer is running Windows 8 or newer with secure boot on, also read the [Booting with secure boot](secure-boot.md) page.

Secondly, please take a look at step 5 and see if you can do that on your computer before proceeding. If you cannot do that (you cannot add a new bootloader entry into your EFI BIOS), there is no point in proceeding. You may want to check this page instead:
[Install to a harddisk when UEFI firmware does not support multiple boot loaders → ](http://lightofdawn.org/wiki/wiki.cgi/SonyLinuxUefiBoot)
or use the [LICK installer](uefi-lick.md).

**Do not use the same fat32 partition that Windows 8 & 10 use for their boot, usually marked sda1 and labeled ESP.**

Windows 8 & 10 use "Fast boot" aka hibernation by default and if you write to that partition while Windows is hibernated, when Windows resumes it will corrupt the ESP's filesystem.

It's a good idea to make a backup of the files on the Windows ESP, just in case you do something stupid.

---

## Step 1

You will need some space on your hard drive to create a couple of new partitions.
Boot into Windows and then:

- Right click on My Computer
- Select Manage
- Click Storage > Disk Management
- Right Click on the drive and click Shrink Volume

![ ](shrink-windows.png)

- Then select the amount of space you want to shrink your C: drive.
- Minimum would be about 2Gb, more is always better.

In the example below the C: drive is being shrunk to 40GB.

![ ](shrink-windows2.png)

---

## Step 2

Boot into Fatdog64 from your CD/DVD/Flash drive.

If you booted from a flash drive, remove it after booting. Then:

- Open the Control Panel
- Click on the Utilities Tab
- Double click on Gparted partition editor. 

![ ](gparted.jpeg)

(Typical Gparted window with fat32 and ext4 partitions added. The "Create new Partition" window is opened for demonstration.)

- Right click on the 'unallocated' partition. This should be the same size that you shrank your C: drive in Windows.
- Select 'New'. The Create new Partition window will pop up.
- On the File system pull-down menu select 'fat32'.
- For 'New size (MiB):' enter 1000. That makes 1GB.
- Enter a Label for the new partition, then click Add.
- Right click on the 'unallocated' partition again.
- Select 'New'. The Create new Partition window will pop up.
- On the File system pull-down menu select 'ext4'.
- For 'New size (MiB):' enter whatever space is left.
- Enter a Label for the new partition, then click Add.

After you're done adding partitions click Apply.

When Gparted gets done you can close it.

---

## Step 3

- From the tray menu, click on 'Restart X server'.
- Click on the new fat32 partition you made to mount it.
- Make an EFI/Boot folder inside this partition.
- Copy the files from /usr/share/refind-bin-0.11.2/refind to your new fat32 partition.
- Rename EFI/Boot/refind_x64.efi to EFI/Boot/bootx64.efi
- Copy vmlinuz and initrd from your bootable CD/DVD/Flash drive to your new fat32 partition.

Your new fat32 partition should look like this:

![ ](uefi-window.jpg)

Note: 0.10.3 is the version of rEFInd. It may be different on your installation.
More details on how to find rEFInd [here](get-refind.md).

---

## Step 4

On your new fat32 partition, rename EFI/boot/refind.conf-sample to refind.conf.
Right click on refind.conf and select Edit With Geany.
The refind.conf should contain this:

		# refind.conf
		# Configuration file for the rEFInd boot menu
		# See the refind.conf-sample file for full details.

		timeout 10
		banner fatdog.png
		scanfor manual

		menuentry "Fatdog64 Linux" {
		icon /EFI/boot/icons/os_fatdog.png
		loader vmlinuz
		initrd initrd
		options savefile=direct:device:sda7:/fd64save
		}
(Change sda7 in this line to whatever your new ext4 partition is. See [boot options](boot-options-savefile.md) for more info.)
		menuentry Fatdog64 without savefile {
		icon /EFI/boot/icons/os_fatdog.png
		loader vmlinuz
		initrd initrd
		options savefile=none
		}

		menuentry "Windows 10" {
		volume ESP
(Change ESP to whatever your normal boot partition is. Usually it's sda1 and usually it is labeled ESP.)
		loader EFIMicrosoftBootbootmgfw.efi
		}

Click on the new ext4 partition you made to mount it.
Then create a new directory named fd64save.

You can skip this step if you want to use a save file instead of a save directory, just modify the options in your refind.conf file to reflect whatever you want to name your save file.

*If you have problems with refind not finding the ESP partition when booting, it may show an error like bootmgfw.efi not found. You can try changing volume from ESP to 0: (That's a zero and a colon. The zero represents the first partition. If the normal boot partition is on sda2, then you would want "volume 1:".)*

If refind still can't find the volume (partition) that the Windows boot loader is on, you can install refind and Fatdog64's kernel and initrd directly to the ESP, if it has the space available. **If you do this you must disable hibernation in Windows.**

To do that open a terminal as the administrator in Windows 8, and type **powercfg -h off**. 
The reason for this is that Windows mounts the ESP and when it hibernates it doesn't sync or unmount it. So if you boot another OS, shutdown, and then un-hibernate (Fast boot) Windows, the ESP's VFAT filesystem becomes corrupted.

---

## Step 5

Now reboot your computer and press f2 to enter UEFI setup (Some computers use a different key to enter setup).
 
Then add your new fat32 partition as a boot option. Unfortunately this process varies quite a bit. Here's the screen a Dell laptop presents:

![ ](uefi-boot-order.JPG)

For this particular laptop you have to disable secure boot to use the "File Browser Add Boot Option", then re-enable it when you're done. Again this process varies a lot.

Generally on the boot tab you will find some way to add a new boot option. After you find the button to add a boot option, you will be asked to select a partition. This is kind of cryptic as well, and might take some guessing. Then you will be asked to browse to a bootable EFI application; this will be EFI/boot/bootx64.efi on your new fat32 partition.

If you can't browse to that path or you can't see the files that you put in your fat32 partition under EFI/boot/, you probably picked the wrong partition.

After you have added your new boot option, move that new boot option to the top of the boot order. Again, this will vary with different UEFI implementations.

Then save and reboot.
