%%textdomain fatdoghelp
![Fatdog](fatdog64.png)
# Networking

The main network connection manager is the Network Tool. The auxiliary connection manager is [Network Setup](Networking-network-setup.md).

---------------------------------

## Network Tool

Network Tool supports wireless and wired connections.

Click its icon in the system tray ![Connect](wpa_gui.png) to set up connections.

If connections need your attention the icon could look like this: ![Network Tool icon when connections need your attention](network-error.png)
 
You can right click to restart the connection. ![WpaGuiRestart](wpa_gui-icon-menu-ambiance-C1.png)

## Connect to Wireless Networks (Network Tool Wifi tab)

The Network Tool automatically connects to one of the enabled network profiles listed in the Manage Networks sub-tab.

![WpaGuiWifi](wpa_gui-wifi-tab.png)

You can press the Scan button to discover which networks are available in your current location. Add new network profiles to the Manage Networks sub-tab as explained below.

To add a new profile and connect to the network:

### Step 1

If your computer has multiple wireless adapters, the Network Tool can only connect using one wireless adapter at the time. Select which one from the Adapter pull-down. See also: Wireless Antenna Manager (below).

### Step 2

Click Scan to open the Scan results window. Click the Scan button if needed to refresh results. You might have to wait several seconds for your network to show.
![WpaGuiwifiScan](wpa_gui-wifi-scan.png)

### Step 3

Double click on the network you want to add and connect to.

### Step 4

Fill in any password information needed. For WPA2-Personal authentication the password is the PSK field.

![WpaGuiWirelessInfo](wpa_gui-wifi-info.png)

### Step 5

Enable the DHCP field to receive an automatic network address. If you prefer to configure a static address disable the DHCP field and press Configure Static Address (see Configuring a Static Address below for further instructions).

### Step 6

Press Add to add the new profile into the Manage Networks sub-tab. Then click Save Configuration in the File menu to save for the next reboot.

### Step 7

On the Current Status sub-tab, you should see a connection being made to your newly added profile, unless the Network Tool has already connected to another network. To manually select a network, use the Network pull-down and press Connect.

### Tips:

 * To always connect to a specific network you can disable other networks in the Manage Networks sub-tab.

 * The Flags column (in the Scan results window) shows the authentication and encryption methods that the selected network supports.

 * If the [WPS] flag is shown you may also use the WPS tab to connect with your network Access Point (AP) without a password. Refer to your AP manufacturer's documentation.


--------------------------------------


## Configuring a Static Address


When you disable DHCP in the Wifi (or Wired) tab you come to this dialog to set a static address. The dialog guesses reasonable defaults for a simple home LAN setup. For more advanced configurations, and for troubleshooting issues, you will need to read up on what each parameter really does. Getting static addressing right needs some experience.

![WpaGuiStatic](wpa_gui-static-ip.png)

### Step 1

Enter IP address, Subnet Mask and Gateway.

### Step 2

   Enter DNS1 address and optionally DNS2. The default values set Google's DNS servers. You may want to replace these with your ISP's DNS server addresses.
   
### Step 3

Select a save method for the new configuration. You can always change the save method later. Choose Interface to tie the static address to your interface name, like wlan0 or eth0. This is recommended if you run Fatdog64 on the same system all the time, like your notebook or desktop system. Choose Mac Address otherwise, for instance, if you carry Fatdog64 on a USB flash key, and boot several systems in different network environments with it.

### Tips:

 * Configuration files for static addresses are located in directory /etc/wpa_gui.

 * Unlike an Interface name, the Mac Address uniquely identifies a network adapter. The interface name (wlan0, wlan1, eth0, and even longer names) is unique within the same computer, but will likely clash if re-used for multiple computers.

 * Linux assigns and remembers Interface names automatically. Sometimes it can be useful to clear all saved names and force Linux to start assigning them again. This can be done from the Network Setup Troubleshooting menu. If you do this, you will need to reconfigure static addresses.

 * Optionally, file /etc/resolv.conf.head — manually edited — allows you to add DNS servers that take precedence over the servers configured with the Network Tool. Both server sets are enabled, but the latter is used only when the former isn't available. Here is a sample resolv.conf.head:

```sh
# static DNS.WATCH nameservers for privacy
  nameserver 84.200.69.80
  nameserver 84.200.70.40
# end of /etc/resolv.conf.head
```


---------------------------------


## Connect to Wired Networks (Network Tool Wired tab)

A wired connection hooks up your computer to your home or business network router with an Ethernet cable.

![WpaGuiWired](wpa_gui-wired-tab.png)

### Step 1

If your computer has multiple wired adapters, the Network Tool can only connect using one wired adapter at a time. Select which one from the Adapter pull-down.

### Step 2

Enable the DHCP field to receive an automatic network address. If you need to configure a static address disable the DHCP field and press Configure Static Address (review Configuring a Static Address).

### Step 3

Link Status should be "up". If it isn't, either the network cable is not connected, Fatdog64 is still busy starting network services, or the adapter isn't properly installed or configured at boot time.

### Step 4

Press Connect/Enable and watch the red "Interface disabled during boot" line change to a green "Interface enabled during boot" line. This refers to the next time you boot the system. At the same time, the current session is connected via the wired adapter.


---------------------------------


## Restarting the Connection

If you have problems connecting to a network, try right clicking on the Network Tool icon and select Restart Connection. This action will restart wireless network services.

If the Network Tool manages your wired connection, this action will also restart wired network services. (The other way to manage wired connections is [Network Setup](Networking-network-setup.md)).

When the Network Tool is left free to automatically select the best network, it will do so based on the order of network entries in the Manage Networks sub-tab, their network security level (WPA/WPA2 is preferred), and their signal strength. Network entries are saved to the configuration file.

Configuration file: /etc/wpa_supplicant.conf.
Wireless services: `wpa_supplicant`, `wpa_cli`, `dhcpcd`.
Wired services: `dhcpcd`.


## Wireless Antenna Manager


The Wireless Antenna Manager applet can be started from the Control Panel > Network tab.

It can be used to temporarily enable or disable the antenna of a wireless adapter. This can help in troubleshooting network connections for computers equipped with multiple wireless adapters.

![FatdogWirelessAntenna](fatdog-wireless-antenna.png)

