%%textdomain fatdoghelp
![ ](fatdog64.png)
# Bluetooth known issues


## 1. Bluetooth does not work.

Like Wi-Fi adapter, the support for bluetooth adapter in Linux varies greatly, depending on hardware vendor support. So the first thing to check is whether your adapter is supported by the Linux kernel.

Intel-based adapters usually work very well with few exceptions. All you need to ensure is you have the latest firmware.

Broadcom-based adapters are very quirky. Some requires firmware that is not publicly available - you need to fish it out from somewhere else (e.g. Windows drivers); and you need to use special tool to upload it to the the adapter. Fatdog64 includes two of those tools: `brcm_patchram_plus` and `brcm_patchram_plus_usb` but due to great variation between models, they may not work.

Run `dmesg` in a terminal and check for signs whether the kernel detect problems with your adapter.
Run `hciconfig hci0 up` in a terminal and see if you have got any error messages.




## 2. Where is the bluetooth applet?

In Fatdog64 800, the bluetooth stack (bluez) is updated to version 5.50 (older Fatdogs used bluez 4.101). This is a major change, and the bluetooth applet used in previous versions does not work with the new bluez. Thus it has been removed. We are still considering a replacement - it could be an existing tool or something that we will write ourselves.

For now, Fatdog offers a complete CLI-based management for bluetooth devices. Aside from `bluetoothctl`, bluez's own CLI tool (which is much improved than older tools), Fatdog64 includes bluez-tools (`bt-adapter`, `bt-device`, `bt-network`) which makes most bluetooth operations such as pairing, connection, and disconnection very simple.
To find out nearby device: bt-adapter -d (press Ctrl-Break when done)

```
To pair with nearby device: bt-agent & bt-device -p XX:XX:XX:XX:XX:XX  (where XX:XX is the bluetooth mac address you get from discovery process, above). When you're done pairing then type killall bt-agent

To connect: bt-device -c XX:XX:XX:XX:XX:XX (this works for all devices: mice, keyboard, speaker, etc)
 
To disconnect: bt-device -d XX:XX:XX:XX:XX:XX

To view all existing paired device: bt-device -l  (this is lower-case L, not a capital i).

To remove a paired device: bt-device -d XX:XX:XX:XX:XX:XX (where XX:XX is the bluetooth mac address from the list, above)
```



## 3. My adapter is supported but it does not work. I plugged it in after the system is up and running.

You need to bring the device up: "hciconfig hci0 up". This is usually done at boot-up but if you haven't plugged automatically, it can't be done, so you will have to do it manually.

Also, if you plan to connect to a bluetooth speaker, then you need to restart the bluetooth service: `service bluetooth restart` . This is because bluealsa (the component that provides bluetooth audio support) will fail to start if there is no bluetooth adapter; so you need to restart the entire stack.


## 4. "Setup Bluetooth Modem", in the Network tab, in Control Panel, does not work.

Because of the major bluez update (see above), it is completely probably that the function does not work anymore.
We currently do not have a device that can be used to test this functionality anymore, so you are on your own.
The relevant function is located in `/usr/sbin/fatdog-bt-find-dun.sh` and `/usr/sbin/fatdog-bt-find-dun.awk`, if you want to troubleshoot it yourself. Don't forget to send a patch if you make it to work.


## 5. My Microsoft Bluetooth Mouse does not work.

Certain bluetooth mice, such as some models of MS mice, requires the "**uhid**" kernel module to work. Otherwise, they can pair, trust and connect, but they will not work.

The solution to this problem is:

1. To load the **uhid** kernel module. This can be done by running **modprobe uhid** in terminal, or, you can do this automatically at every boot by editing **/etc/modules** and adding a line containing the word **uhid** all by itself.

2. Then, you need to edit **/etc/bluetooth/input.conf** and uncomment the line **UserspaceHID=true** (remove the **#** in front of it), and then restart the bluetooth service (do that from __Control Panel --> System --> Manage Servers and Services__).
