%%textdomain fatdoghelp
![ ](fatdog64.png)
# Boot Options

# Advanced Parameters

%%nopot yes
[savefile](boot-options-savefile.md) - key - [net](boot-options-net.md) - [base](boot-options-base.md)

## key{n}

%%nopot no
The name of the parameter is actually **key1**, **key2**, **key3**, etc. Each word specifies the location of a keyfile used for decrypting a LUKS partition or savefile. Each decryption requires one key, e.g. if you put an encrypted savefile on an encrypted partition, you will need to provide two keys (one for decrypting the partition, one for decrypting the savefile). The keys must be in sequential order without any gaps.

The parameter is specified as follows: key{n}=[wait:]type:id:path[:crypt]. Type can be device, label, or uuid, while id varies depending on the type.

%%nopot yes
### id

%%nopot no
For device, id is the device id (e.g. sdb3), for label, it is the volume label of the device, and for uuid it is the uuid of the device.

%%nopot yes
### path

%%nopot no
path gives the actual path to the keyfile, on the given device.

%%nopot yes
### wait

%%nopot no
wait is an optional parameter that specifies that the system should give you a prompt to plug in a removable device (e.g. USB flash drive) before attempting to load the key from that device. This enables you to boot a system without the removable device plugged in, only plug it in at the time you want to load the key, and then remove it again.

%%nopot yes
### crypt

%%nopot no
crypt is an optional parameter that specifies that the device that holds the keyfile is encrypted. You can use either "crypt" or "dmcrypt". You have to use a passphrase to unlock this; you can't use another "key{n}" parameter to unlock a partition that holds another key.

---

The complete list of options for key{n} is:

    key{n}=[wait:]device:dev:path[:crypt]
    key{n}=[wait:]label:label:path[:crypt]
    key{n}=[wait:]uuid:uuid:path[:crypt]
    key{n}=ask

If you specify ask, you will be asked to enter the details at boot time.

---

%%nopot yes
[savefile](boot-options-savefile.md) - key - [net](boot-options-net.md) - [base](boot-options-base.md)

%%nopot no

---

[Advanced and Troubleshooting Parameters](boot-options-trouble.md)
