%%textdomain fatdoghelp
![ ](fatdog64.png)
# Boot Options

# Advanced Parameters

%%nopot yes
savefile - [key](boot-options-key.md) - [net](boot-options-net.md) - [base](boot-options-base.md)

## savefile

%%nopot no
This parameter tells Fatdog64 where to find the savefile. It can be specified in three different ways:

### savefile=layer:location

This instructs Fatdog64 to load the savefile from the specified **location**, and using the **layering mode** specified.

		savefile=none

This instructs Fatdog64 not to use any savefile at at all.
(In earlier versions of Fatdog, this parameter is called **pfix=ram**)

		savefile=ask

This instructs Fatdog64 to ask for the savefile details during boot time.
At boot time, you can either specify **none** or **layer**:**location**.

---

You can choose **layer** from one of the following:

		direct

This tells Fatdog64 to use the savefile directly - any writes will go direct to the savefile.

		ram

This tells Fatdog64 to use the RAM layer. Any writes will first be stored and collated in RAM, to be periodically flushed to the actual savefile.

---

**location** is split into two - the first part is always the "command" - you have to type this as is, and the second part is options. These are the "commands" and the "options".

%%nopot yes
### local:path:crypt

%%nopot no
Where:

- "local" is the command; you have to specify it as is. It tells Fatdog64 to search for the specified savefile (see below) on all local devices - harddrives, flash drive, CD/DVD drives, etc.

- "path" is the path to the savefile including the filename. Example: /fd64/600/fd64save.3fs. Path is optional; if you don't specify it, the default of /fd64save.ext4 will be used.

- "crypt" is an option, which can be either **crypt** (cryptoloop) or **dmcrypt** (LUKS).
It informs Fatdog64 that the device that the savefile is in is encrypted (not the savefile itself). When this is specified, Fatdog64 will ask for a password during booting and try to decrypt the device before attempting to mount it. Crypt is optional.

As of version 811, Fatdog64 can detect LUKS encrypted devices automatically, so **dmcrypt** doesn't have to be specified anymore.

%%nopot yes
### usb:path:crypt

%%nopot no
- The "usb" command is identical to the "local" command above except that it will only search USB local devices instead of all devices. The limitations of the "local" command also apply here.

%%nopot yes
### device:dev:path:crypt

%%nopot no
Where:

- "device" is the command; you have to specify it as is. It tells Fatdog64 that the savefile is available on the specified device (see below).

- "dev" is the name of the device/partition where the savefile is stored, for example **sda1**, **sdb**, etc.

- "path" is the path to the savefile including the filename. Example: /fd64/600/fd64save.3fs. Path is optional; if you don't specify it, the default of /fd64save.ext4 will be used.

- "crypt" is an option, which can be either **crypt** (cryptoloop) or **dmcrypt** (LUKS).
It informs Fatdog64 that the device that the savefile is in is encrypted (not the savefile itself). When this is specified, Fatdog64 will ask for a password during booting and try to decrypt the device before attempting to mount it. Crypt is optional.

As of version 811, Fatdog64 can detect LUKS encrypted devices automatically, so **dmcrypt** doesn't have to be specified anymore.

%%nopot yes
### label:dev-label:path:crypt

%%nopot no
The "label" command is identical to the "device" command, except that instead of specifying the device/partition by its device name, you specify the device label.

You can name your device/partition using tools such as Gparted.

Note: The label cannot contain space or colon.

%%nopot yes
### uuid:dev-uuid:path:crypt

%%nopot no
The "uuid" command is identical to the "device" command, except that instead of specifying the device/partition by its device name, you specify its uuid.

You can set the uuid for your device/partition using tools such as Gparted.

Note: A uuid cannot contain space or colon.

%%nopot yes
### cifs:user:pass:unc:path

%%nopot no
Where:

- "cifs" is the command; you have to specify it as is. It tells Fatdog64 that the savefile is available on the specified CIFS (SAMBA/Windows) share. For this command to work, you also need to tell Fatdog64 to enable network during boot - using the **net** parameter.

- "user" is the userid for the cifs share. If user is set as **+**, Fatdog64 will ask you for the user/password at boot time.

- "pass" is the password for the cifs share. **Note:** whatever you specify here can be seen in /proc/cmdline after the system boots up. If you don't want anyone to see your cifs password, use **+:+** as the user password and Fatdog64 will ask it at boot time - nothing will be shown in /proc/cmdline.

- "unc" is the UNC (Universal Naming Convention) path to the CIFS share.

- Specify the IP address (or the hostname) of the CIFS server, as well as the shared folder name. Do not include the path within the shared folder - if you need to specify this, use the "path" option below. UNC cannot include space. Example: //192.168.1.5/MyShare.

- "path" is the path to the savefile including the filename. Path is optional; if you don't specify it, the default of /fd64save.ext4 will be used.

%%nopot yes
### nbd:host:port:crypt

%%nopot no
Where:

- "nbd" is the command; you have to specify it as is. It tells Fatdog64 that the savefile is available on an NBD (network block device) on a specified hostname and port. For this command to work, you also need to tell Fatdog64 to enable network during boot, and of course don't tell it not to load modules (or drivers) during boot - use the **net** parameter.

- "host" is the hostname of the NBD server. You can specify either IP address or hostname.

- "port" is the port number to connect to on the NBD server.

- "crypt" is an option, which can be either **crypt** (cryptoloop) or **dmcrypt** (LUKS).
It informs Fatdog64 that the device that the savefile is in is encrypted (not the savefile itself). When this is specified, Fatdog64 will ask for a password during booting and try to decrypt the device before attempting to mount it. Crypt is optional.

As of version 811, Fatdog64 can detect LUKS encrypted devices automatically, so **dmcrypt** doesn't have to be specified anymore.


%%nopot yes
### multi:dev:path:skip

%%nopot no
Where:

- "multi" is the command; you have to specify it as is. It tells Fatdog64 to use multisession mode.

- "dev" is the device on which to keep the multisession savefiles.
If not specified, this will be **sr0**, presumably the first CD/DVD drive on your computer.
If this is not the case, you need to set it to the correct device.

- "path" is the path to the savefile including the filename.
Path is optional; if you don't specify it, the default of /fd64save.ext4 will be used.
Note that in multisession mode, only the basename (without extension) is used, and Fatdog64 will prepend the "multi" prefix and append the current date and time when the session is saved. For example, for the default filename of /fd64save.ext4, the actual session savefile will be /multi-fd64save-2012-04-23T12-54+1000-save.sfs - thus the date and timestamp will be changed with every save.

- "skip" is an integer that tells Fatdog64 to skip loading the last "skip" number of sessions.  This option allows you to filter for bad sessions or sessions you don't want to use.

For example, if you have 100 sessions, you can specify "5" as the skip value here to tell Fatdog64 to load only the first 95 (=100 - 5) sessions.

After this, you can prepare a new DVD and save the session there - it effectively removes the last 5 sessions.

"skip" is optional; if you don't specify it, Fatdog64 will load all available sessions.

--

Note: multisession mode has only been tested with DVD+RW.

It will not work with CD, it may or may not work with DVD-R/DVD+R/DVD-RW/DVD-RAM and others.

It will also work with hard drives and flash drives - but please ensure that they have been properly set-up and initialised.

Multisession does not support encryption.

### btrfscompress=[zlib|lzo|zstd]

This is an optional boot parameter that tells Fatdog64 to enable compression on btrfs-formatted savefile.

Both **zlib** and **zstd** (the latter since kernel v5.1) can have an optional compression level, zlib 1-9 and zstd 1-15, e.g.: **btrfscompress=zlib:5**.

Note that if you use this parameter, the specified compression will be enabled on all btrfs devices mounted by init.

---

All commands that specify a savefile path, with the exception of **multi**, also accept a directory.

If a directory is specified, the sessions will be saved into that directory (="save" directory) instead of a savefile.

This works if the filesystem the partition is on is ext2/3/4; for others the success rate varies.
The directory must already exist - Fatdog will not create and use one if it doesn't.

You can use the entire partition by specifying **"/"** as the save directory - this would be identical to "save to partition" under Puppy Linux.

Note: Under previous versions of Fatdog (Fatdog 600 and 610), the same thing is accomplished using "+" to save to partition. This is no longer supported.

A savefile can be encrypted (but not a "save" directory).

This is done by having the filename contain `_crypt_`, e.g. `fd64save_crypt_me.ext4`

This is separate and different from the **:crypt** option, which says that the device/partition where the savefile is is encrypted.

You can also specify: `_dmcrypt_`, what tells Fatdog64 to access the savefile using dm-crypt (LUKS) instead of cryptoloop which is used if you use `_crypt_`.

As of version 811, Fatdog64 can detect LUKS encrypted savefiles automatically, so `_dmcrypt_` doesn't have to be a part of the filename anymore.

The default setting for savefile if you don't specify anything is **savefile=direct:local**.
This approximates the behaviour of previous versions of Fatdog (and Puppy Linux).

### Some examples:

		savefile=direct:device:sda1
savefile named fd64save.ext4 located in root directory of /dev/sda1, save directly to it

		savefile=ram:device:sda2:/fd600/fd64save.3fs
use savefile named fd64save.3fs located in /fd600 directory of /dev/sda2, use  RAM layer

		savefile=ram:usb
use savefile named fd64save.ext4 located in root directory of the first found usb device, use RAM layer

		savefile=direct:multi
use multisession on device /dev/sr0

---

%%nopot yes
savefile - [key](boot-options-key.md) - [net](boot-options-net.md) - [base](boot-options-base.md)

%%nopot no

---

[Advanced and Troubleshooting Parameters](boot-options-trouble.md)
